<?php
/** 
 * Alert Entity 
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\Alerts
 */
class Alert extends Entity {
	
	// DB Model
	const BASEENTITY = 'alerts';
	const LISTVIEW = 'alertlist';
	
	// Alert context types
	const CONTEXTTYPE_USER = 1;
	const CONTEXTTYPE_DATARECORD_LLO = 2;
	const CONTEXTTYPE_DATARECORD_NFP = 3;
	const CONTEXTTYPE_DATASET_EFP = 4;
	const CONTEXTTYPE_JOB = 5;
	
	// Alert type 
	const TYPE_LLO_DATARECORD2VALIDATE = 1;
	const TYPE_LLO_DATARECORD4REVIEW = 2;
	const TYPE_LLO_DATARECORD2APPROVE = 3;
	const TYPE_NFP_DATARECORD2VALIDATE = 4;
	const TYPE_NFP_DATARECORD4REVIEW = 5;
	const TYPE_NFP_DATARECORD2APPROVE = 6;
	const TYPE_EFP_DATARECORD2VALIDATE = 7;
	const TYPE_EFP_DATARECORD4REVIEW = 8;
	const TYPE_EFP_DATARECORD2APPROVE = 9;
	const TYPE_JOB_NFP_EXPORT_ERROR = 10;
	const TYPE_JOB_EFP_PUSH_ERROR = 11;
	const TYPE_USER_LOCKED = 12;
	const TYPE_USER_REQUEST_UNLOCK = 13;
	const TYPE_USER_REQUEST_NEWPASSWORD = 14;
	
	public $id;
	public $userid;
	public $alerttypeid;
	public $statuscodeid;
	public $roleid;
	public $organisationid;
	public $contextid;
	public $contextdescription;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 * 
	 * @param int $id (optional)
	 */
	function Alert($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * Prepares new alert for DB
	 * 
	 * @param int $alerttypeid
	 * @param int $roleid
	 * @param int $organisationid
	 * @param string $contextid
	 * @param string $contextdescription
	 * @param int $userid (optional)
	 */
	function setNew($alerttypeid, $roleid, $organisationid, $contextid, $contextdescription, $userid = null) {
		$this->alerttypeid = $alerttypeid;
		$this->roleid = $roleid;
		$this->organisationid = $organisationid;
		if (isset ( $contextid )) {
			$this->contextid = $contextid;
		}
		if (isset ( $contextdescription )) {
			$this->contextdescription = $contextdescription;
		}
		$this->statuscodeid = __ALERT_STATUS_UNREAD;
		if ($userid) {
			$this->userid = $userid;
		}
	}
}

?>
