<?php
/**
 * Entity Data Structures
 * 
 * Support for Datastrucutres Commom, NDP and LDP
 * @author tm - Advantis 
 * @version 1.0.1
 * @package Backend\DataStructures
 */
class DataStructures extends Entity {
	
	// DB Model
	const BASEENTITY = 'datastructuredefinitions';
	const LISTVIEW = 'dsdlist';
	
	// Level type
	const LEVEL_CMP = __DSD_LEVEL_CMP;
	const LEVEL_NDP = __DSD_LEVEL_NDP;
	const LEVEL_LDP = __DSD_LEVEL_LDP;
	public $id;
	public $statisticaltypeid;
	public $description;
	public $levelcodeid; // Item code identifier for level structure CodeList(CMDM,NDP,LDP).
	public $parentid;
	public $versionregistryid; // The new version is registered when the structure is final.
	public $active;
	public $code;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function DataStructures($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * Prepares new DataStructure
	 *
	 * @param int $statisticaltypeid        	
	 * @param int $levelcodeid        	
	 * @param int $versionregistryid        	
	 * @param string $description        	
	 */
	function setNew($statisticaltypeid, $levelcodeid, $versionregistryid, $description) {
		$this->statisticaltypeid = $statisticaltypeid;
		$this->levelcodeid = $levelcodeid;
		$this->versionregistryid = $versionregistryid;
		$this->active = 0;
		$this->description = $description;
	}
}

?>

