<?php
/**
 * Token support
 * 
 * @author ba - Advantis
 * @version 1.0.1
 * @package Backend\Limesurvey
 */
class token {
}

/**
 * 
 */
/**
 * Manager class for lime survey api integration
 *
 * @author ba - Advantis
 * @version 1.0.1
 * @package Backend\Limesurvey
 */
class LimeManager {
	private $rpcclient = null;
	private $sessionkey = null;
	
	/**
	 * Construtor
	 */
	function LimeManager() {
	}
	
	/**
	 * API Connection
	 */
	function api_connect() {
		if (! $this->rpcclient || ! $this->sessionkey) {
			
			$this->rpcclient = new jsonRPCClient ( LS_BASEURL . '/admin/remotecontrol' );
			
			$this->sessionkey = $this->rpcclient->get_session_key ( LS_USER, LS_PASSWORD );
		}
	}
	
	/**
	 * Release connection
	 */
	function release() {
		$this->rpcclient->release_session_key ( $this->sessionkey );
		$this->sessionkey = null;
	}
	
	/**
	 * Create Lime survey Token via API
	 *
	 * @param int $surveyid        	
	 * @param User $user        	
	 * @return string
	 */
	function createToken($surveyid, $user) {
		$this->api_connect ();
		
		$token = new token ();
		$token->email = $user->email;
		$token->firstname = html_entity_decode($user->fullname);
		$token->lastname = "";
		
		$resulttoken = $this->rpcclient->add_participants ( $this->sessionkey, $surveyid, array (
				$token 
		), true );
		
		$this->release ();
		
		return $resulttoken;
	}
	
	/**
	 * Set Lime Survey Token properties via API
	 *
	 * @param string $tokenid        	
	 * @param int $surveyid        	
	 * @param string $properties        	
	 */
	function setTokenProperties($tokenid, $surveyid, $properties) {
		$this->api_connect ();
		
		$a = $this->rpcclient->set_participant_properties ( $this->sessionkey, $surveyid, $tokenid, $properties );
		
		// print_r($a);
		
		$this->release ();
	}
}

?>