<?php
/**
 * 
 * Logs Manager
 * 
 * Log support/Auditing
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Base
 */
class LogManagement {
	
	/**
	 *
	 * @param unknown $obj        	
	 * @param unknown $operation        	
	 */
	function log_entity($obj, $operation) {
		$em = new EntityManager ( "logs" );
		
		$log = new stdClass ();
		$log->username = Session::get_user ()->username;
		$log->timestamp = time ();
		$log->entity = $obj->internal_name;
		$log->valuetext = serialize ( $obj );
		$log->operation = $operation;
		
		if ($obj->internal_name == 'users' || $obj->internal_name == 'organisations') {
			
			$log->logtypeid = __LOGTYPE_SECURITY;
		}
		
		$log->loglevelid = __LOGLEVEL_CRUD;
		
		$em->create ( $log );
	}
	/**
	 *
	 * @param unknown $valuetext        	
	 * @param string $operation        	
	 * @param string $context        	
	 * @param string $logtype        	
	 * @param string $loglevel        	
	 * @param string $username        	
	 */
	function log($valuetext, $operation = 'other', $context = null, $logtype = __LOGTYPE_DATA, $loglevel = __LOGLEVEL_AUDIT, $username = null) {
		$em = new EntityManager ( "logs" );
		
		$log = new stdClass ();
		
		if ($username == null) {
			$username = Session::get_user ()->username;
		}
		$log->username = $username;
		$log->timestamp = time ();
		$log->valuetext = $valuetext;
		$log->operation = $operation;
		$log->entity = $context;
		$log->loglevelid = $loglevel;
		$log->logtypeid = $logtype;
		
		$em->create ( $log );
	}
}

?>