<?php
/**
 * List Of Values Manager
 * 
 * Performs List of Value operations
 * @author tm - Advantis Solutions
 * @version 1.0.1
 * @package Backend\LOV
 */
class LovManager {
	
	/**
	 * Constructor
	 */
	function LovManager() {
	}
	
	/**
	 * Gets Lov description code
	 *
	 * @param int $id        	
	 * @return string|NULL
	 */
	public function getLov_DescriptionCode($id) {
		$em = new EntityManager ( "codelists" );
		
		$list = $em->load ( 'id=?', array (
				$id 
		) );
		
		if (isset ( $list ) && count ( $list ) > 0) {
			return $list [0]->descriptioncode;
		} else {
			return null;
		}
	}
	
	/**
	 * Get elements for a specific Lov if active
	 *
	 * @param int $idParent        	
	 * @return array
	 */
	public function getLov($idParent) {
		$em = new EntityManager ( "codelistitems" );
		
		$list = $em->load ( 'codelistid=? and active = true', array (
				$idParent 
		) );
		
		return $list;
	}
	
	/**
	 * Gets a specific value from a given list
	 *
	 * @param array $list        	
	 * @param int $id        	
	 * @return element from $list if exists
	 */
	function getLov_item($list, $id) {
		if (is_array ( $list )) {
			$aitem = array_filter ( $list, function ($e) use(&$id) {
				return $e->id == $id;
			} );
			
			return array_pop ( $aitem );
		}
	}
	
	/**
	 * get Lov_StatisticalType
	 *
	 * @return array
	 */
	function getLov_StatisticalType() {
		$em = new EntityManager ( "statisticaltypes" );
		
		$list = $em->load ( 'active = true' );
		
		return $list;
	}
	
	/**
	 * Gets from codelistitems a specific description code by its id
	 *
	 * @param int $id        	
	 * @return string|NULL
	 */
	function getItemDescriptionCode($id) {
		$item = new Entity ( 'codelistitems', $id );
		
		if (isset ( $item )) {
			return $item->descriptioncode;
		} else {
			return null;
		}
	}
	
	/**
	 * get __LOV_SYS_VOIDREASON
	 *
	 * @return array
	 */
	function getLov_VoidReason() {
		return $this->getLov ( __LOV_SYS_VOIDREASON );
	}
	
	/**
	 * get __LOV_RELIABILITY
	 *
	 * @return array
	 */
	function getLov_Reliability() {
		return $this->getLov ( __LOV_RELIABILITY );
	}
	
	/**
	 * get __LOV_TIMEFREQUENCY
	 *
	 * @return array
	 */
	function getLov_TimeFrequency() {
		return $this->getLov ( __LOV_TIMEFREQUENCY );
	}
	
	/**
	 * get __LOV_SYS_DATATYPE
	 *
	 * @return array
	 */
	function getLov_SysDatatype() {
		return $this->getLov ( __LOV_SYS_DATATYPE );
	}
	
	/**
	 * get __LOV_SYS_LEVELSTRUCTURE
	 *
	 * @return array
	 */
	function getLov_SysLevelStructure() {
		return $this->getLov ( __LOV_SYS_LEVELSTRUCTURE );
	}
	
	/**
	 * get __LOV_SYS_ALERTSTATUS
	 *
	 * @return array
	 */
	function getLov_AlertStatus() {
		return $this->getLov ( __LOV_SYS_ALERTSTATUS );
	}
	
	/**
	 * get __LOV_SOURCECHECK
	 *
	 * @return array
	 */
	function getLov_SourceCheck() {
		return $this->getLov ( __LOV_SOURCECHECK );
	}
	
	/**
	 * get __LOV_EVENTOFREFERENCE
	 *
	 * @return array
	 */
	function getLov_EventOfReference() {
		return $this->getLov ( __LOV_EVENTOFREFERENCE );
	}
	
	/**
	 * get __LOV_YESNOUNKNOWN
	 *
	 * @return array
	 */
	function getLov_YNU() {
		return $this->getLov ( __LOV_YESNOUNKNOWN );
	}
	
	/**
	 * get __LOV_SEX
	 *
	 * @return array
	 */
	function getLov_Sex() {
		return $this->getLov ( __LOV_SEX );
	}
	
	/**
	 * get __LOV_CITIZENSHIPCHECK
	 *
	 * @return array
	 */
	function getLov_CitizenshipCheck() {
		return $this->getLov ( __LOV_CITIZENSHIPCHECK );
	}
	
	/**
	 * get __LOV_LOCATIONCHECK
	 *
	 * @return array
	 */
	function getLov_LocationCheck() {
		return $this->getLov ( __LOV_LOCATIONCHECK );
	}
	
	/**
	 * get __LOV_AGECHECK
	 *
	 * @return array
	 */
	function getLov_AgeCheck() {
		return $this->getLov ( __LOV_AGECHECK );
	}
	
	/**
	 * get __LOV_AGEGROUP
	 *
	 * @return array
	 */
	function getLov_AgeGroup() {
		return $this->getLov ( __LOV_AGEGROUP );
	}
	
	/**
	 * get __LOV_MARITALSTATUS
	 *
	 * @return array
	 */
	function getLov_MaritalStatus() {
		return $this->getLov ( __LOV_MARITALSTATUS );
	}
	
	/**
	 * get __LOV_EDUCATIONALLEVEL
	 *
	 * @return array
	 */
	function getLov_EducationLevel() {
		return $this->getLov ( __LOV_EDUCATIONALLEVEL );
	}
	/**
	 * get __LOV_HOUSEHOLD
	 *
	 * @return array
	 */
	function getLov_Household() {
		return $this->getLov ( __LOV_HOUSEHOLD );
	}
	
	/**
	 * get __LOV_RELATIONSHIPTOSUBJECT
	 *
	 * @return array
	 */
	function getLov_RealtionshipToSubject() {
		return $this->getLov ( __LOV_RELATIONSHIPTOSUBJECT );
	}
	
	/**
	 * get __LOV_MEANSOFRECRUITMENT
	 *
	 * @return array
	 */
	function getLov_MeansOfRecruitment() {
		return $this->getLov ( __LOV_MEANSOFRECRUITMENT );
	}
	
	/**
	 * get __LOV_CONDITIONSOFRECRUITMENT
	 *
	 * @return array
	 */
	function getLov_ConditionOfRecruitment() {
		return $this->getLov ( __LOV_CONDITIONSOFRECRUITMENT );
	}
	
	/**
	 * get __LOV_REASONFORMIGRATION
	 *
	 * @return array
	 */
	function getLov_ReasonForMigration() {
		return $this->getLov ( __LOV_REASONFORMIGRATION );
	}
	
	/**
	 * get __LOV_MEANSOFTRANSPORTATION
	 *
	 * @return array
	 */
	function getLov_MeansOfTransportation() {
		return $this->getLov ( __LOV_MEANSOFTRANSPORTATION );
	}
	
	/**
	 * get __LOV_TRAVELCOMPANIONS
	 *
	 * @return array
	 */
	function getLov_TravelCompanions() {
		return $this->getLov ( __LOV_TRAVELCOMPANIONS );
	}
	
	/**
	 * get __LOV_USEOFDOCUMENTS
	 *
	 * @return array
	 */
	function getLov_UseOfDocuments() {
		return $this->getLov ( __LOV_USEOFDOCUMENTS );
	}
	
	/**
	 * get __LOV_VICTIMSTATUS
	 *
	 * @return array
	 */
	function getLov_VictimStatus() {
		return $this->getLov ( __LOV_VICTIMSTATUS );
	}
	
	/**
	 * get __LOV_FORMOFEXPLOITATION
	 *
	 * @return array
	 */
	function getLov_FormOfExploitation() {
		return $this->getLov ( __LOV_FORMOFEXPLOITATION );
	}
	
	/**
	 * get __LOV_MEANSOFCONTROL
	 *
	 * @return array
	 */
	function getLov_MeansOFControl() {
		return $this->getLov ( __LOV_MEANSOFCONTROL );
	}
	
	/**
	 * get __LOV_MEANSOFEXIT
	 *
	 * @return array
	 */
	function getLov_MeansOfExit() {
		return $this->getLov ( __LOV_MEANSOFEXIT );
	}
	
	/**
	 * get __LOV_TYPEOFASSISTANCE
	 *
	 * @return array
	 */
	function getLov_TypeOfAssintance() {
		return $this->getLov ( __LOV_TYPEOFASSISTANCE );
	}
	
	/**
	 * get __LOV_TYPEOFINVOLVEMENT
	 *
	 * @return array
	 */
	function getLov_TypeOfInvolvment() {
		return $this->getLov ( __LOV_TYPEOFINVOLVEMENT );
	}
	
	/**
	 * get __LOV_TRAFFICKERSTATUS
	 *
	 * @return array
	 */
	function getLov_TraffickerStatus() {
		return $this->getLov ( __LOV_TRAFFICKERSTATUS );
	}
	
	/**
	 * get __LOV_PROSECUTIONSERVICEDECISION
	 *
	 * @return array
	 */
	function getLov_ProsecutionServiceDecision() {
		return $this->getLov ( __LOV_PROSECUTIONSERVICEDECISION );
	}
	
	/**
	 * get __LOV_EMPLOYMENT
	 *
	 * @return array
	 */
	function getLov_Employment() {
		return $this->getLov ( __LOV_EMPLOYMENT );
	}
	
	/**
	 * get __LOV_COURTDECISION
	 *
	 * @return array
	 */
	function getLov_CourtDecision() {
		return $this->getLov ( __LOV_COURTDECISION );
	}
	
	/**
	 * get __LOV_COURTSENTENCE
	 *
	 * @return array
	 */
	function getLov_CourtSentence() {
		return $this->getLov ( __LOV_COURTSENTENCE );
	}
	
	/**
	 * get __LOV_RESIDENCEPERMIT
	 *
	 * @return array
	 */
	function getLov_ResidencePermit() {
		return $this->getLov ( __LOV_RESIDENCEPERMIT );
	}
	
	/**
	 * get __LOV_REGISTERINGORGANISATION
	 *
	 * @return array
	 */
	function getLov_RegisteringOrganisation() {
		return $this->getLov ( __LOV_REGISTERINGORGANISATION );
	}
	
	/**
	 * get __LOV_COUNTRIES
	 *
	 * @return array
	 */
	function getLov_Countries() {
		return $this->getLov ( __LOV_COUNTRIES );
	}
	
	/**
	 * get __LOV_RECORDSTATUS
	 *
	 * @return array
	 */
	function getLov_RecordStatus() {
		return $this->getLov ( __LOV_RECORDSTATUS );
	}
	
	/**
	 * get __LOV_PUBLISHSTATUS
	 *
	 * @return array
	 */
	function getLov_PublishStatus() {
		return $this->getLov ( __LOV_PUBLISHSTATUS );
	}
	
	/**
	 * get __LOV_ALERTCONTEXTS
	 *
	 * @return array
	 */
	function getLov_AlertContexts() {
		return $this->getLov ( __LOV_ALERTCONTEXTS );
	}
	
	/**
	 * get __LOV_SYS_CLUSTERMEMBERSTATUS
	 *
	 * @return array
	 */
	function getLov_ClusterMemberStatus() {
		return $this->getLov ( __LOV_SYS_CLUSTERMEMBERSTATUS );
	}
	
	/**
	 * get __LOV_CLUSTERSTATUS
	 *
	 * @return array
	 */
	function getLov_ClusterStatus() {
		return $this->getLov ( __LOV_CLUSTERSTATUS );
	}
	
	/**
	 * get __LOV_SYS_PRIORITY
	 *
	 * @return array
	 */
	function getLov_Priority() {
		return $this->getLov ( __LOV_SYS_PRIORITY );
	}
	
	/**
	 * get __LOV_SYS_DETECTIONPROCESS
	 *
	 * @return array
	 */
	function getLov_DetectionProcess() {
		return $this->getLov ( __LOV_SYS_DETECTIONPROCESS );
	}
	
	/**
	 * get __LOV_RECORDSETSTATUS
	 *
	 * @return array
	 */
	function getLov_RecordsetStatus() {
		return $this->getLov ( __LOV_RECORDSETSTATUS );
	}
}

?>