<?php
/**
 * Recorset Entity
 * 
 * Recordset object supports NFP master records of DataRecords
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\Clusters 
 */
class Recordset extends Entity {
	
	// DB Model
	const BASEENTITY = 'recordsets';
	const HISTORYENTITY = 'recordsethistory';
	const LISTVIEW = 'recordsetlist';
	const QUESTIONS = 'recordsetquestions';
	const MEMBERSVIEW = 'recordsetmemberslist';
	
	public $id;
	public $clusterid;
	public $statuscodeid;
	public $userid;
	public $masterrecordid;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function Recordset($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * Prepares new Recordset
	 *
	 * @param int $clusterid        	
	 * @param int $userid        	
	 */
	function setNew($clusterid, $userid) {
		$this->clusterid = $clusterid;
		$this->userid = $userid;
		$this->statuscodeid = __RECORDSET_STATUS_CONFIRMED; // startup setup status
	}
	
	/**
	 * Creates a history entry for the current state of the object
	 *
	 * @return boolean
	 */
	function createHistory() {
		if (! isset ( $this->id )) {
			return false;
		} else {
			$da = new DataAccess ();
			$cfgdb = new ConfigDB ();
			$schema = $cfgdb->connections ["DEFAULT"] ["DBSCHEMA"];

			$da->func_get ("INSERT INTO " . $schema . "." . self::HISTORYENTITY . "(recordsetid, statuscodeid, userid,actiondate) select id, statuscodeid, userid, now() from base." . self::BASEENTITY . " where id = :id", array(':id' => $this->id)  );
			return true;
		}
	}
	/**
	 * gets array from DB model with DataRecords information associated with this recordset
	 *
	 * @return NULL|array
	 */
	function get_members() {
		if (! isset ( $this->id ))
			return null;
		
		$em = new EntityManager ( Recordset::MEMBERSVIEW );
		
		$results = $em->load ( "recordset_id = :recid order by record_id asc ", array(':recid' => $this->id) );
		
		return $results;
	}
}

?>

