<?php
require_once "class-version.php";

/**
 * Elements Versioning Manager
 * 
 * Performs Version operations
 * @author tm - Advantis Solutions
 * @version 1.0.1
 * @package Backend\DataStructures
 */
class VersionManager {
	
	/**
	 * start version with update "datefrom" with today date
	 *
	 * @param integer $id        	
	 */
	function start_version($id) {
		$version = new Version ( $id );
		$version->validfrom = date ( "Ymd" );
		$version->save ();
		
		return true;
	}
	
	/**
	 * close version with update "dateto" with today date
	 *
	 * @param integer $id        	
	 */
	function close_version($id) {
		$version = new Version ( $id );
		$version->validto = date ( "Ymd" );
		$version->save ();
		
		return true;
	}
	
	/**
	 * Checks if version is closed
	 *
	 * @param integer $id        	
	 * @return boolean
	 */
	function is_closed_version($id) {
		$version = new Version ( $id );
		
		return (isset ( $version->validto ));
	}
	
	/**
	 * Checks if version is live
	 *
	 * @param integer $id        	
	 * @return boolean
	 */
	function is_live_version($id) {
		$version = new Version ( $id );
		
		return (isset ( $version->validfrom ));
	}
}

?>