<?php
/**
 * Version Entity
 *  
 * Support class for versioning all versionable entities in MoSy model
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataStructures
 */
class Version extends Entity {
	
	// DB model
	const BASEENTITY = 'versionregistry';
	
	public $id;
	public $code;
	public $description;
	public $validfrom;
	public $validto;
	public $annotation;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function Version($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 *
	 * Prepares new version for DB
	 *
	 * @param string $code        	
	 * @param string $annotation        	
	 * @param string $description        	
	 */
	function setNew($code, $annotation, $description) {
		$this->code = $code;
		$this->annotation = $annotation;
		$this->description = $description;
	}
}

?>
