<?php
/**
 * EFPanalyse Context
 *
 * Context for DataSet Record analysis at EFP level
 *
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataSets
 */
class context_efpanalyse extends context {
	public $contextname = "efpanalyse";
	
	/**
	 * Constructor & Authorization
	 */
	function context_efpanalyse() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action shows Dataset listing acording to filtering via POST
	 */
	function index() {
		Navigation::resolve_step ( $this );
		
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_GET );
		
		$pvars = $this->data ['pvars'];
		
		$list = array ();
		
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'fromdate', $_POST ['fromdate'], $da::TYPE_DATE ) );
		array_push ( $args, $da->helper_args ( 'todate', $_POST ['todate'], $da::TYPE_DATE ) );
		array_push ( $args, $da->helper_args ( 'statisticaltype', $_POST ['type'], $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'orgid', $_POST ['organisationid'], $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'status', __RECORD_STATUS_COMPLETED, $da::TYPE_TEXT ) );
		
		$sql = "select id , statisticaltypeid , organisationname , statuscodeid , setdate , fromperiod ,toperiod , annotation
				from base.datasetfileselect(:fromdate,:todate, :statisticaltype, :orgid, :status)";
		
		$list = $da->func_get ( $sql, $args );
		
		$this->screen ( $this->contextname . "/index", array (
				'list' => $list,
				'pvars' => $pvars,
				'navkey' => $navkey 
		) );
	}
}

?>