<?php 
require_once 'app/class-language-manager.php';
require_once 'app/class-user-manager.php';

/**
 * Default context
 * 
 * Shows default page on Backend 
 *  
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Backend 
 */
class context_index extends context {
	
	/**
	 * 
	 * Contructor and Auth
	 */
	
	function context_index(){
		
		main::check_auth_session();
		
	}
	
	/**
	 * 
	 * Entry point and homepage selector based on user profile
	 * 
	 */	
	function index() {
		
		/*echo "<pre>";
			print_r($_SESSION);
		echo "</pre>";
		*/
		
		
		// homepage selector
		switch(Session::get_activerole()->role_code) {
		
			case 'LC':
				header("Location: ".__SITEBASE."/collectdata");
				break;
			case 'LA':
				header("Location: ".__SITEBASE."/collectdata");
				break;
			case 'LP':
				header("Location: ".__SITEBASE."/collectdata");
				break;
			case 'NC':
				if (__EFP == 0) {
					header("Location: ".__SITEBASE."/nfpcollect");
				} else  {
					header("Location: ".__SITEBASE."/efpcollect");
				}					
				break;
			case 'NA':
				if (__EFP == 0) {
					header("Location: ".__SITEBASE."/nfpanalyse");
				} else  {
					header("Location: ".__SITEBASE."/efpanalyse");
				}
				
				break;
			case 'NP':
						if (__EFP == 0) {
					header("Location: ".__SITEBASE."/nfppublish");
				} else  {
					header("Location: ".__SITEBASE."/efppublish");
				}					

				break;
			case 'DM':
				header("Location: ".__SITEBASE."/dataaudit");
				break;				

			case 'DA':
				header("Location: ".__SITEBASE."/dataaudit");
				break;

			case 'SM':
				header("Location: ".__SITEBASE."/securityaudit");
				break;
			case 'SA':
				header("Location: ".__SITEBASE."/securityaudit");
				break;
                        case 'OM':
				header("Location: ".__SITEBASE."/reports");




				break;
			default:
				$this->screen('index');
			
		}
		//end homepage selector
		
	}
	
    /**
     * 
     * Performs logout of the current user
     * 
     */
	function logout() {
		
		/** log login */
  		LogManagement::log("User logout","logout","login",__LOGTYPE_SECURITY);
		/** end log login*/
		$_SESSION = array();
		header("Location: ".__LOGINPAGE);
		
	} 
	
	/**
	 * 
	 * changes the active role
	 */
	function role(){
		
		$usermanager = new UserManager();
		
		$roleid = $_REQUEST['id'];
		
		$usermanager->set_active_role($roleid);
		
		header("Location:".__SITEBASE."/");
		
	}
	
	/**
	 * 
	 * changes active language
	 */
	function lang() {
		
		$langid = $_REQUEST['id'];
		
		if ($langid != Session::get_language()->id) {
			
			LanguageManager::unload_language();
			
			$language = new Entity("languages",$langid);
			
			Session::set_language($language);
						
			LanguageManager::load_descriptions();	
			LanguageManager::load_resources();
			
			//set user language
			
			$user = Session::get_user();
			$user->languageid = $langid;
			$user->save();
						
			//end set user language
			
		}
		
		header("Location:".__SITEBASE."/");
		
	}
	
}

?>