<?php
require_once 'app/class-export-manager.php';
require_once 'app/class-alert-manager.php';

/**
 * Context for Export managment
 *
 * Export manager for XML dataset files for EFP integration
 * 
 * @author ba - Advantis
 * @version 1.0.1
 * @package Backend\FilesJobs
 */
class context_nfpexport extends context {
	public $contextname = "nfpexport";
	
	/**
	 * Constructor method
	 *
	 * validates authorization for the user in session based on the current role
	 */
	function context_nfpexport() {
		main::check_auth_session ();
	}
	
	/**
	 * action : victims export xml file process
	 */
	function victims() {
		$exp = new ExportManager ();
		
		$exp->victims ();
	}
	
	/**
	 * action : traffickers export xml file process
	 */
	function traffickers() {
		$exp = new ExportManager ();
		
		$exp->traffickers ();
	}
	
	/**
	 * action : Automatic scheduled batch to create export files to EFP integration
	 */
	function batch() {

		if (Session::get_user ()) {
				
			$processingUser = Session::get_user ()->id;
			$processingUsername = $user->username;
			$processingRole = Session::get_activerole ()->roleid;
			$processingOrg = Session::get_org ()->id;
		} else { // batch
				
			$processingUser = __USER_SYSTEM;
			$user = new User ( $processingUser );
			$processingUsername = $user->username;
			$processingRole = __ROLE_DATA_MANAGER;
			$processingOrg = __DATA_COLLECTOR_ORGANISATION;
		}
		
		LogManagement::log ( " JOB :  NFP publish Files : start ", "other", "JOB", __LOGTYPE_DATA, __LOGLEVEL_AUDIT, $processingUsername );
		
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'automatic', 1, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'statistictype', __STATISTICAL_TYPE_VICTIMS, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select base.nfp_published(:automatic, :statistictype ,:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->nfp_published == null) {
			
			$this->victims ();
			
			LogManagement::log ( " JOB : NFP publish victim records", "other", "JOB", __LOGTYPE_DATA , __LOGLEVEL_AUDIT, $processingUsername );
		} elseif (isset ( $res [0] ) && $res [0]->nfp_published == 0) {
			
			LogManagement::log ( " JOB :  NFP publish victim records no results", "other", "JOB", __LOGTYPE_DATA , __LOGLEVEL_AUDIT, $processingUsername );
		} else {
			AlertManager::new_alert ( ALERT::TYPE_JOB_NFP_EXPORT_ERROR, __ROLE_DATA_MANAGER, __DATA_COLLECTOR_ORGANISATION, null, null );
			LogManagement::log ( " JOB :  NFP publish victim error : " . $res [0]->nfp_published, "other", "JOB", __LOGTYPE_DATA, __LOGLEVEL_ERROR , $processingUsername );
		}
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'automatic', 1, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'statistictype', __STATISTICAL_TYPE_TRAFFICKERS, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select base.nfp_published(:automatic,:statistictype ,:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->nfp_published == null) {
			
			$this->traffickers ();
			
			LogManagement::log ( " JOB : NFP publish trafficker records", "other", "JOB", __LOGTYPE_DATA, __LOGLEVEL_AUDIT, $processingUsername );
			
			header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
		} elseif (isset ( $res [0] ) && $res [0]->nfp_published == 0) {
			
			LogManagement::log ( " JOB : NFP publish trafficker records no results", "other", "JOB", __LOGTYPE_DATA , __LOGLEVEL_AUDIT, $processingUsername );
		} else {
			AlertManager::new_alert ( ALERT::TYPE_JOB_NFP_EXPORT_ERROR, __ROLE_DATA_MANAGER, __DATA_COLLECTOR_ORGANISATION, null, null );
			LogManagement::log ( " JOB :  NFP trafficker victim error : " . $res [0]->nfp_published, "other", "JOB", __LOGTYPE_DATA, __LOGLEVEL_ERROR, $processingUsername );
		}
		
		LogManagement::log ( " JOB :  NFP publish Files : end ", "other", "JOB", __LOGTYPE_DATA , __LOGLEVEL_AUDIT, $processingUsername );
	}
}