<?php
require_once "app/class-record.php";
require_once 'app/class-export-manager.php';

/**
 * NFPpublish Context
 *
 * Context for Data Record publication at NFP level
 *
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataRecords
 */
class context_nfppublish extends context {
	public $contextname = "nfppublish";
	
	/**
	 * Constructor & Authorization
	 */
	function context_nfppublish() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action shows Dataset listing acording to filtering via POST
	 */
	function index() {
		Navigation::resolve_step ( $this );
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_POST );
		
		$pvars = $this->data ['pvars'];
		
		$list = array ();
		
		$da = new DataAccess ();
		
		$args = array ();
		
		array_push ( $args, $da->helper_args ( 'recordstatus', __RECORD_STATUS_VALID . "," . __RECORD_STATUS_INVALID, $da::TYPE_TEXT ) );
		
		$sql = "select id as uid, statisticaltypeid as type , organisationname as organisation, statuscodeid as status, clusterid as cluster, publishcodeid as publication, embargodate, annotation from
				base.responserecordselect(null, null, null, null, null , null, null, null, :recordstatus)";
		
		$list = $da->func_get ( $sql, $args );
		
		$aset = array ();
		
		foreach ( $list as $item ) {
			array_push ( $aset, $item->uid );
		}
		
		$this->screen ( $this->contextname . "/index", array (
				'list' => $list,
				'pvars' => $pvars,
				'assistedSet' => $aset,
				'rules' => $listRules,
				'navkey' => $navkey 
		) );
	}
	
	/**
	 * Marks datarecords as aproved for publication
	 */
	function markpublishable() {
		//Navigation::resolve_step ( $this );
		//$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_POST );
		
		$listrecordsvalid = false;
		
		$arrrecordids = get_ck_list_ids ( $_POST );
		
		if (count ( $arrrecordids ) > 0) {
			
			$em = new EntityManager ( DataRecord::LISTVIEW );
			$list = $em->load ( "id in (" . implode ( ",", $arrrecordids ) . ")" );
			
			foreach ( $list as $item ) {
				$listrecordsvalid = (! isset ( $item->clusterid ) && $item->statuscodeid == __RECORD_STATUS_VALID && $item->publishcodeid == __PUBLISHED_STATUS_UNPUBLISHED);
				if (! $listrecordsvalid)
					break;
			}
		}
		
		if ($listrecordsvalid) {
			$listids = implode ( ",", $arrrecordids );
			
			$da = new DataAccess ();
			
			$args = array ();
			array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
			array_push ( $args, $da->helper_args ( 'rids', '{' . $listids . '}', $da::TYPE_TEXT ) );
			
			$sql = "select base.nfp_publishable(:userid , :rids )";
			
			$res = $da->func_get ( $sql, $args );
			
			if (isset ( $res [0] ) && $res [0]->nfp_publishable == null) {
				
				setNotification ( getSuccess ( "msg_markpublishable_sucess" ));
								
				LogManagement::log ( " NFP mark publishable records sucess", "update", "Records", __LOGTYPE_DATA );
			} else {
				$rsp = getError ( "msg_markpublishable_error" );
				
				Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
				
				LogManagement::log ( " NFP mark publishable records error : " . $res [0]->nfp_publishable, "update", "Records", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
			}
		} else {
			$rsp = getError ( "msg_markpublishable_error" );
			
			Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " NFP mark publishable records error", "update", "Records", __LOGTYPE_DATA,__LOGLEVEL_ERROR );
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
	
	/**
	 * Processes publishable victims data record to xml file to publication
	 */
	function publishvictims() {
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'automatic', 0, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'statistictype', __STATISTICAL_TYPE_VICTIMS, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select base.nfp_published(:automatic, :statistictype ,:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->nfp_published == null) {
			
			$exp = new ExportManager ();
			
			$exp->victims ();
			
			setNotification ( getSuccess ( "msg_publish_victims" ) );
			
			LogManagement::log ( " NFP publish victim records", "update", "Records", __LOGTYPE_DATA );
		} elseif (isset ( $res [0] ) && $res [0]->nfp_published == 0) {
			
			setNotification(getNotification ( "msg_no_item_publish_victims" ), Notification::TYPE_WARNING);
			
			LogManagement::log ( " NFP publish victim records no results", "update", "Records", __LOGTYPE_DATA );
		} else {
			setNotification(getError( "msg_error_publish_victims" ),Notification::TYPE_ERROR);
						
			LogManagement::log ( " JOB :  NFP publish victim error : " . $res [0]->nfp_published, "update", "JOB", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
	
	/**
	 * Processes publishable traffickers data record to xml file to publication
	 */
	function publishtraffickers() {
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'automatic', 0, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'statistictype', __STATISTICAL_TYPE_TRAFFICKERS, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select base.nfp_published(:automatic,:statistictype ,:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->nfp_published == null) {
			
			$exp = new ExportManager ();
			
			$exp->traffickers ();
			
			setNotification(getSuccess ( "msg_publish_traffickers" ));
						
			LogManagement::log ( " NFP publish trafficker records", "update", "Records", __LOGTYPE_DATA );
			
			header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
		} elseif (isset ( $res [0] ) && $res [0]->nfp_published == 0) {
			
			setNotification(getNotification ( "msg_no_item_publish_traffickers" ),Notification::TYPE_WARNING);
			
			//Navigation::set_step ( $_GET [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " NFP publish trafficker records no results", "update", "Records", __LOGTYPE_DATA );
		} else {
			setNotification(getError ( "msg_error_publish_trafficker" ),Notification::TYPE_ERROR);
			
			//Navigation::set_step ( $_GET [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " JOB :  NFP trafficker victim error : " . $res [0]->nfp_published, "update", "JOB", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
	
	/**
	 * * Generates NFP pre realease statistics
	 */
	function prereleasestats() {
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select statistic.calculate_indicators(:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->calculate_indicators == null) {
			
			setNotification(getSuccess ( "msg_pre_relase_statistics" ));
			
			//Navigation::set_step ( $_GET [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( "NFP pre realease statistics", "update", "Records", __LOGTYPE_DATA );
		} elseif ((isset ( $res [0] ) && $res [0]->calculate_indicators == 0)) {
			
			setNotification(getNotification( "msg_pre_relase_statistics_noaction" ), Notification::TYPE_WARNING);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " NFP pre realease statistics no new data to calculate : " . $res [0]->calculate_indicators, "update", "Records", __LOGTYPE_DATA );
		} else {
			
			setNotification(getError ( "msg_pre_relase_statistics_error" ), Notification::TYPE_ERROR);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " NFP pre realease statistics error : " . $res [0]->calculate_indicators, "update", "Records", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
	
	/**
	 * Generates NFP final realease statistics
	 */
	function releasestats() {
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select statistic.finalstatistics(:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->finalstatistics == null) {
			
			setNotification(getSuccess( "msg_relase_statistics" ));
			
			//Navigation::set_step ( $_GET [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( "EFP final realease statistics", "update", "Records", __LOGTYPE_DATA );
		} elseif ((isset ( $res [0] ) && $res [0]->finalstatistics == 0)) {
			
			setNotification(getNotification( "msg_relase_statistics_noaction" ), Notification::TYPE_WARNING);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " NFP final realease statistics no new data to calculate : " . $res [0]->finalstatistics, "update", "Records", __LOGTYPE_DATA );
		} else {
			
			setNotification(getError ( "msg_relase_statistics_error" ),Notification::TYPE_ERROR);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " NFP final realease statistics error : " . $res [0]->finalstatistics, "update", "Records", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
	
	
}

?>