<?php
/**
 * Security Auditing context
 *
 * Performs auditing exploration on security operations
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Backend\Auditing
 */
class context_securityaudit extends context {
	
	/**
	 * Constructor & Authorization
	 */
	function context_securityaudit() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action Lists log actions acording to POST filter
	 */
	function index() {
		$init_timestamp = time() - (24*60*60*7);
		$end_timestamp = time();
		$arrValues = array();
		
		/**
		 * filter TYPE __LOGTYPE_SECURITY
		 */
		$filter .= " logtypeid=" . __LOGTYPE_SECURITY;
		/**
		 * end filter TYPE
		 */
		
		if ($_POST['submit']) {
			
			if ($_POST ['init_date']) {
				$init_timestamp = strtotime ( $_POST ['init_date'] );
				
				if ($filter)
					$filter .= " AND ";
				
				$filter .=  " :init_date <= timestamp";

				$arrValues[':init_date'] = $init_timestamp;
			}
			
			if ($_POST ['end_date']) {
				$end_timestamp = strtotime ( $_POST ['end_date'] );
				
				if ($filter)
					$filter .= " AND ";
				
				$filter .=  " :end_date >= timestamp";

				$arrValues[':end_date'] = ($end_timestamp + 86400);
			}
			
			if ($_POST ['username']) {
				
				if ($filter)
					$filter .= " AND ";
				
				$filter .= "username=:username";

				$arrValues[':username'] = $_POST["username"];
			}
			
			if ($_POST ['operation']) {
				
				if ($filter)
					$filter .= " AND ";
				
				$filter .= "operation=:operation";

				$arrValues[':operation'] = $_POST ['operation'];
			}
			
			if ($_POST ['context']) {
				
				if ($filter)
					$filter .= " AND ";
				
				$filter .= "entity=:context";
				$arrValues[':context'] = $_POST ['context'];
			}
			// log level
			if ($_POST ['loglevel']) {
				
				if ($filter)
					$filter .= " AND ";
				
				$filter .= "loglevelid=:loglevel";
				$arrValues['loglevel'] = $_POST ['loglevel'];
			}
		}else {
			
			if ($filter)
					$filter .= " AND ";
					
			$filter .= " :init_date <= timestamp  AND :end_date >= timestamp";
			$arrValues[':init_date'] = $init_timestamp;
			$arrValues[':end_date'] = ($end_timestamp + 86400);
		}
		// get log levels
		$loglv = new EntityManager ( 'loglevellist' );
		$loglist = $loglv->load ( 'languageid=:langid', array(':langid' => Session::get_language ()->id ));
		$em = new EntityManager ( 'logs' );

		$list = $em->load ( $filter . ' order by timestamp desc', $arrValues );
		
		$this->screen ( "auditing/security", array (
				'list' => $list,
				'loglist' => $loglist,
				'initdate' => $init_timestamp,
				'enddate' => $end_timestamp
		) );
	}
}

?>