<?php
require_once "app/class-wf-engine.php";
require_once "app/class-dataset.php";
require_once 'app/class-file-manager.php';

/**
 * DataSet Context
 *
 * DataSet Context support for EFP datasets from responses imported via xml file
 *
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataSets
 */
class context_setdetail extends context {
	public $contextname = "setdetail";
	
	/**
	 * Constructor & Authorization
	 */
	function context_setdetail() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action shows dataset detail by id
	 */
	function index() {
		$bakkey = Navigation::resolve_step ( $this );
		
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_POST );
		
		$uid = (isset ( $_POST ['uid'] )) ? $_POST ['uid'] : $_GET ['uid'];
		
		$list = array ();
		
		if ($uid) {
			
			$em = new EntityManager ( Dataset::LISTVIEW );
			
			$listtmp = $em->load ( 'id = :id', array(':id' => $uid) );
			
			if (isset ( $listtmp ) && count ( $listtmp ) > 0) {
				
				$ds = $listtmp [0];
				
				$emi = new EntityManager ( 'indicators', 'STATISTIC' );
				
				$listIndicators = $emi->load ( 'statisticaltypeid = :statisticaltypeid', array(':statisticaltypeid' =>  $ds->statisticaltypeid) );
				
				$list = array ();
				
				if ($_POST ['indicator']) {
					$emid = new EntityManager ( 'receivedmacrodata' );
					$list = $emid->load ( 'receivedfileid = :uid and indicatorid = :indicatorid' , array(':uid' => $uid, ':indicatorid' => $_POST ['indicator']) );
				}
				
				$wfe = new WFEngine ();
				
				$listStates = $wfe->get_wf_dataset_next_states ( SESSION::get_activerole ()->role_code, $ds->statuscodeid, $uid );
			} else { // error
				
				LogManagement::log ( "No indicators to display for dataset", "display", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
			}
			
			$rfile = new Entity ( 'receivedfiles', $uid );
			
			$ftype = $rfile->statisticaltypeid == __STATISTICAL_TYPE_VICTIMS ? 'victims' : ($rfile->statisticaltypeid == __STATISTICAL_TYPE_TRAFFICKERS ? 'traffickers' : '');
			$fileok = FileManager::verifyfile ( $rfile->organisationid, $rfile->id, $ftype );
			
			$this->screen ( $this->contextname . "/index", array (
					'list' => $list,
					'listindicator' => $listIndicators,
					'item' => $ds,
					'pvars' => $pvars,
					'navkey' => $navkey,
					'bakkey' => $bakkey,
					'states' => $listStates,
					'idIndicator' => $_POST ['indicator'],
					'fileok' => $fileok 
			) );
		} else { // error
			LogManagement::log ( "dataset to display not found", "display", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
			
			header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl ( $this->contextname ) );
		}
	}
	
	/**
	 * Saves dateset data
	 */
	function save() {
		$bakkey = Navigation::resolve_step ( $this );
		
		if ($_POST) {
			
			$uid = $_REQUEST ['uid'];
			$ds = new Dataset ( $uid );
			
			$wfe = new WFEngine ();
			$role = SESSION::get_activerole ()->role_code;
			$listStates = $wfe->get_wf_dataset_next_states ( $role, $ds->statuscodeid, $ds->id );
			
			$step = $wfe::search_step ( $listStates, $_POST ['setstatus'] );
			
			if ($step != null) {
				
				try {
					$needrollback = false;
					Transaction::beginTransaction ();
					
					$ds->statuscodeid = $_POST ['setstatus'];
					$ds->annotation = $_POST ['annotation'];
					$ds->save ();
					
					$wfe->run_postaction_step ( $step );
					
					Transaction::commit ();
					
					LogManagement::log ( "save dataset " . $ds->id, "update", "Dataset", __LOGTYPE_DATA );
				} catch ( Exception $exp ) {
					Transaction::rollback ();
					dump_errorlog ( 'setdetail', 'save', $exp->getMessage () );
					header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl ( $this->contextname ) );
				}
			} else { // error
				$rsp = getError ( "msg_error_save_dataset" );
				
				Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
				
				LogManagement::log ( "save dataset error : parameters error", "update", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
			}
			
			header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl ( $this->contextname ) );
		}
	}
	
	/**
	 * downloads dataset xml support file
	 */
	function downloadfile() {
		$idfile = $_REQUEST ['id'];
		
		if (isset ( $idfile )) {
			
			$obj = new Entity ( "receivedfiles", $idfile );
			
			$type = $obj->statisticaltypeid == __STATISTICAL_TYPE_VICTIMS ? 'victims' : ($obj->statisticaltypeid == __STATISTICAL_TYPE_TRAFFICKERS ? 'traffickers' : '');
			
			$nfp = $obj->organisationid;
			
			if ($obj) {
				
				$contents = FileManager::retrievefile_EFP ( $nfp, $idfile, $type );
				
				if ($contents) {
					header ( 'Expires: 0' );
					header ( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
					header ( 'Content-Type: application/octet-stream' );
					header ( 'Content-Disposition: attachment;filename="' . $nfp . '_' . $idfile . '.xml"' );
					header ( 'Content-Transfer-Encoding: binary ' );
					;
					echo $contents;
				} else {
					
					LogManagement::log ( "download file error : no content", "display", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
				}
			}
		} else {
			
			LogManagement::log ( "download file error : parameters error", "display", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
	}
}

?>