<?php
require_once "app/class-user.php";
require_once "app/class-user-manager.php";

/**
 * User context
 *
 * Enables User management
 * 
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Backend\Users
 *         
 */
class context_usersettings extends context {
	
	/**
	 * Constructor & Authorization
	 */
	function context_usersettings() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action
	 */
	function index($pvars = null) {
		$user = new User ( Session::get_user ()->id );
		
		$this->screen ( 'usersettings/index', array (
				'user' => $user 
		) );
	}
	
	/**
	 * Saves user definitions
	 */
	function save() {
		if ($_POST) {
			
			// check errors
			
			if ($_POST ['passwd'] != $_POST ['confirm_passwd']) {
				
				return $this->edit ( array (
						'error' => 1,
						'message' => R ( 'error_passwords_dont_match' ) 
				) );
			}
			//
			
			$user = Session::get_user ();
			$user->contact = $_POST ["contact"];
			
			if ($_POST ['password_changed']) {
				$user->passwd = UserManager::generate_password ( $_POST ['passwd'] );
			}
			
			$user->save ();
		}
		
		header ( 'Location:' . __SITEBASE . '/usersettings' );
	}
}