<?php
/**
 * web sig Context
 * 
 * SIG operations
 * @author Fred - Advantis
 * @version 1.0.1
 * @package Backend\SIG
 */
class context_websig extends context {
	
	/**
	 * Constructor & Authorization
	 */
	function context_websig() {
		main::check_auth_session ();
	}
	
	/**
	 * default action
	 */
	function index() {
		$this->screen ( 'websig/index', null, "websig" );
	}
	
	/**
	 * ajax support
	 */
	function get_serviceslist() {
		// ajax
	}
	
	/**
	 * ajax support
	 */
	function get_indicFiltersIds() {
		// ajax
	}
	
	/**
	 * ajax support
	 */
	function get_cntr() {
		// ajax
	}
	
	/**
	 * ajax support
	 */
	function get_json() {
		// ajax
	}
	
	/**
	 * Modal support
	 */
	function modal()  {
	
		$this->screen('websig/index',null,"websigmodal");
	}
}

if (is_ajax ()) {
	if (isset ( $_POST ["action"] ) && ! empty ( $_POST ["action"] )) {
		$action = $_POST ["action"];
		switch ($action) {
			case "get_serviceslist" :
				get_serviceslist ( $_POST ["groupName"] );
				break;
			case "get_indicFiltersIds" :
				get_indicFiltersIds ( $_POST ["type"], $_POST ["gender"], $_POST ["agegroup"], $_POST ["status"], $_POST ["citizenship"], $_POST ["formfexplotation"] );
				break;
			case "get_cntr" :
				get_cntr ( $_POST ["lat"], $_POST ["lng"] );
				break;
			case "get_json" :
				get_json ( $_POST ["context"], $_POST ["type"], $_POST ["gender"], $_POST ["agegroup"], $_POST ["status"], $_POST ["citizenship"], $_POST ["formfexplotation"], $_POST ["placeof_exploit"], $_POST ["placeof_recruit"], $_POST ["placeof_waypoint"], $_POST ["dateexploitfrom"], $_POST ["dateexploitto"], $_POST ["daterecruitfrom"], $_POST ["daterecruitto"] );
				break;
		}
	}
}

/**
 * Function to check if the request is an AJAX request
 * 
 * @return boolean
 */
function is_ajax() {
	return isset ( $_SERVER ['HTTP_X_REQUESTED_WITH'] ) && strtolower ( $_SERVER ['HTTP_X_REQUESTED_WITH'] ) == 'xmlhttprequest';
}

/**
 * 
 * @param unknown $context
 * @param unknown $type
 * @param unknown $gender
 * @param unknown $agegroup
 * @param unknown $status
 * @param unknown $citizenship
 * @param unknown $formfexplotation
 * @param unknown $placeof_exploit
 * @param unknown $placeof_recruit
 * @param unknown $placeof_waypoint
 * @param unknown $dateexploitfrom
 * @param unknown $dateexploitto
 * @param unknown $daterecruitfrom
 * @param unknown $daterecruitto
 */
function get_json($context, $type, $gender, $agegroup, $status, $citizenship, $formfexplotation, $placeof_exploit, $placeof_recruit, $placeof_waypoint, $dateexploitfrom, $dateexploitto, $daterecruitfrom, $daterecruitto) {
	$da = new DataAccess ( 'WEBSIG' );
	$item = array ();
	
	if (isset ( $gender ) && ! empty ( $gender )) {

		$args = array();
		array_push ( $args, $da->helper_args ( 'gender', $gender, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 10 and code like :gender";
		
		$r = $da->func_get ( $sql, $args );

		$item ["genderid"] = $r [0]->id;
	} else {
		$item ["genderid"] = null;
	}
	
	if (isset ( $agegroup ) && ! empty ( $agegroup )) {

		$args = array();
		array_push ( $args, $da->helper_args ( 'agegroup', $agegroup, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 14 and code like :agegroup";
		
		$r = $da->func_get ( $sql, $args );

		$item ["agegroupid"] = $r [0]->id;
	} else {
		$item ["agegroupid"] = null;
	}
	
	if (isset ( $status ) && ! empty ( $status )) {
		$args = array();
		array_push ( $args, $da->helper_args ( 'status', $status, $da::TYPE_TEXT ) );

		if ($type == "1") {
			$sql = "Select id From base.codelistitems cl where codelistid = 26 and code like :status";
		} else {
			$sql = "Select id From base.codelistitems cl where codelistid = 33 and code like :status";
		}

		$r = $da->func_get ( $sql, $args );

		$item ["status"] = $r [0]->id;
	} else {
		$item ["status"] = null;
	}
	
	if (isset ( $citizenship ) && ! empty ( $citizenship )) {

		$args = array();
		array_push ( $args, $da->helper_args ( 'citizenship', $citizenship, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 37 and code like :citizenship";
		
		$r = $da->func_get ( $sql, $args );

		$item ["citizenshipid"] = $r [0]->id;
	} else {
		$item ["citizenshipid"] = null;
	}
	
	if (isset ( $formfexplotation ) && ! empty ( $formfexplotation )) {

		$args = array();
		array_push ( $args, $da->helper_args ( 'formfexplotation', $formfexplotation, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 27 and code like :formfexplotation";
		
		$r = $da->func_get ( $sql, $args );

		$item ["formfexplotation"] = $r [0]->id;
	} else {
		$item ["formfexplotation"] = null;
	}
	
	if (isset ( $placeof_recruit ) && ! empty ( $placeof_recruit )) {
		$item ["placeofrecruit"] = "'" . $placeof_recruit . "'";
	} else {
		$item ["placeofrecruit"] = null;
	}
	if (isset ( $placeof_exploit ) && ! empty ( $placeof_exploit )) {
		$item ["placeofexploit"] = "'" . $placeof_exploit . "'";
	} else {
		$item ["placeofexploit"] = null;
	}
	if (isset ( $placeof_waypoint ) && ! empty ( $placeof_waypoint )) {
		$item ["placeofwaypoint"] = "'" . $placeof_waypoint . "'";
	} else {
		$item ["placeofwaypoint"] = null;
	}
	
	if (isset ( $dateexploitfrom ) && ! empty ( $dateexploitfrom )) {
		$item ["dateexploitfrom"] = "'" . $dateexploitfrom . "'";
	} else {
		$item ["dateexploitfrom"] = null;
	}
	if (isset ( $dateexploitto ) && ! empty ( $dateexploitto )) {
		$item ["dateexploitto"] = "'" . $dateexploitto . "'";
	} else {
		$item ["dateexploitto"] = null;
	}
	if (isset ( $daterecruitfrom ) && ! empty ( $daterecruitfrom )) {
		$item ["daterecruitfrom"] = "'" . $daterecruitfrom . "'";
	} else {
		$item ["daterecruitfrom"] = null;
	}
	if (isset ( $daterecruitto ) && ! empty ( $daterecruitto )) {
		$item ["daterecruitto"] = "'" . $daterecruitto . "'";
	} else {
		$item ["daterecruitto"] = null;
	}
	
	$args = array();
	array_push ( $args, $da->helper_args ( 'context', $context, $da::TYPE_TEXT ) );
	array_push ( $args, $da->helper_args ( 'type', $type, $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'genderid', $item ["genderid"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'agegroupid', $item ["agegroupid"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'citizenshipid', $item ["citizenshipid"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'formfexplotation', $item ["formfexplotation"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'status', $item ["status"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'placeofrecruit', $item ["placeofrecruit"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'placeofexploit', $item ["placeofexploit"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'placeofwaypoint', $item ["placeofwaypoint"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'dateexploitfrom', $item ["dateexploitfrom"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'dateexploitto', $item ["dateexploitto"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'daterecruitfrom', $item ["daterecruitfrom"], $da::TYPE_TEXT) );
	array_push ( $args, $da->helper_args ( 'daterecruitto', $item ["daterecruitto"], $da::TYPE_TEXT) );
		
	$sql = "select * from geo.geostats_clusters(:context,:type,5,:genderid,:agegroupid,:citizenshipid,:formfexplotation,:status,:placeofrecruit,:placeofexploit,:placeofwaypoint,:dateexploitfrom,:dateexploitto,:daterecruitfrom,:daterecruitto)";
	$r = $da->func_get ( $sql, $args );

	$myjson = $r [0]->geostats_clusters;
	
	echo html_entity_decode($myjson);
}

/**
 * 
 * @param unknown $type
 * @param unknown $gender
 * @param unknown $agegroup
 * @param unknown $status
 * @param unknown $citizenship
 * @param unknown $formfexplotation
 */
function get_indicFiltersIds($type, $gender, $agegroup, $status, $citizenship, $formfexplotation) {
	$da = new DataAccess ( 'WEBSIG' );
	$item = array ();
	
	if (isset ( $gender ) && ! empty ( $gender )) {
		$args = array();
		array_push ( $args, $da->helper_args ( 'gender', $gender, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 10 and code like :gender";
		
		$r = $da->func_get ( $sql, $args );

		$item ["genderid"] = $r[0]->id;
	}
	if (isset ( $agegroup ) && ! empty ( $agegroup )) {
		$args = array();
		array_push ( $args, $da->helper_args ( 'agegroup', $agegroup, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 14 and code like :agegroup";
		
		$r = $da->func_get ( $sql, $args );

		$item ["agegroupid"] = $r [0]->id;
	}
	if (isset ( $status ) && ! empty ( $status )) {
		$args = array();
		array_push ( $args, $da->helper_args ( 'status', $status, $da::TYPE_TEXT ) );

		if ($type == "1") {
			$sql = "Select id From base.codelistitems cl where codelistid = 26 and code like :status";
		} else {
			$sql = "Select id From base.codelistitems cl where codelistid = 33 and code like :status";
		}

		$r = $da->func_get ( $sql, $args );

		$item ["status"] = $r [0]->id;
	}
	if (isset ( $citizenship ) && ! empty ( $citizenship )) {
		$args = array();
		array_push ( $args, $da->helper_args ( 'citizenship', $citizenship, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 37 and code like :citizenship";
		
		$r = $da->func_get ( $sql, $args );

		$item ["citizenshipid"] = $r [0]->id;
	}
	
	if (isset ( $formfexplotation ) && ! empty ( $formfexplotation )) {

		$args = array();
		array_push ( $args, $da->helper_args ( 'formfexplotation', $formfexplotation, $da::TYPE_TEXT ) );
		
		$sql = "Select id From base.codelistitems cl where codelistid = 27 and code like :formfexplotation";
		
		$r = $da->func_get ( $sql, $args );

		$item ["formfexplotation"] = $r [0]->id;
	}
	
	echo html_entity_decode(json_encode ( $item ));
}

/**
 * 
 * @param unknown $groupName
 */
function get_serviceslist($groupName) {
	$da = new DataAccess ( 'WEBSIG' );

	$args = array();
	

	$sql = "SELECT s.*,sv_type.type_name,sv_version.version_name,sv_imgf.format_name,sv_gff.getfeatformat_name FROM geo.services s left join geo.services_types sv_type on (s.service_type = sv_type.id)" . " left join geo.services_version sv_version on (s.service_version = sv_version.id)" . " left join geo.services_imgformat sv_imgf on (s.service_imgformat = sv_imgf.id)" . " left join geo.services_getfeatformat sv_gff on (s.service_getfeatformat = sv_gff.id)";
	
	if ($groupName != "") {
		array_push ( $args, $da->helper_args ( 'groupname', $groupName, $da::TYPE_TEXT ) );
		$sql = $sql . " where group_name like :groupname";
	}
	
	$r = $da->func_get ( $sql, $args );

	$list = array ();
	
	$rec = array ();
	foreach ( $r as $line ) {
		foreach ( $line as $key => $value ) {
			$rec [$key] = $value;
		}
		array_push ( $list, $rec );
	}
	
	echo html_entity_decode(json_encode ( $list ));
}

/**
 * 
 * @param unknown $lat
 * @param unknown $lng
 */
function get_cntr($lat, $lng) {
	// sleep(3);
	$da = new DataAccess ( 'WEBSIG' );
	$item = array ();
	
	/*$sql = "select cntr_id,cntr_name from geo.cntr_2010_03m where st_intersects(geom, (st_setsrid((st_makepoint($lng,$lat)),4258)))";
	$r = $da->query ( $sql );*/

	$args = array();
	array_push ( $args, $da->helper_args ( 'lng', $lng, $da::TYPE_TEXT ) );
	array_push ( $args, $da->helper_args ( 'lat', $lat, $da::TYPE_TEXT ) );
		
	$sql = "select cntr_id,cntr_name from geo.cntr_2010_03m where st_intersects(geom, (st_setsrid((st_makepoint(:lng,:lat)),4258)))";
		
	$r = $da->func_get ( $sql, $args );	

	$item ["cntr_code"] = $r[0]->cntr_id;
	$item ["cntr_name"] = $r[0]->cntr_name;
	
	echo html_entity_decode(json_encode ( $item ));
}

?>