<?php
require_once 'includes/class-encription.php';
require_once 'app/class-file-manager.php';

/**
 * WS Context
 *
 * Context for NFP ws exposing to EFP to return xml dataset file request
 *
 * @author tmouzinho - Advantis Solutions
 * @version 1.0.1
 * @package Backend\Files
 */
class context_ws extends context {
	public $contextname = "ws";
	
	/**
	 * Constructor & Authorization
	 */
	function context_ws() {
		
		// main::check_auth_session();
	}
	
	/**
	 * get action
	 */
	function get() {
		$time = $_REQUEST ['t'];
		
		$em = new EntityManager ( 'publishfiles' );
		
		$list = $em->load ( 'creationdate > :time AND efporgid=:efporgid', array(':time' => $time, ':efporgid' => __NFP_CODE) );
		
		if (count ( $list ) == 0) {
			
			echo 'nofile';
			exit (); /* returns 'nofile' - nothing to deliver after that date */
		}
		
		/* deliver 1st one - after date receiveid */
		
		$type = $list [0]->statisticaltypeid == __STATISTICAL_TYPE_VICTIMS ? 'victims' : ($list [0]->statisticaltypeid == __STATISTICAL_TYPE_TRAFFICKERS ? 'traffickers' : '');
		
		$this->retrievefile ( $list [0]->id, $type );
	}
	
	/**
	 * reads text stream from file and encripts
	 *
	 * @param int $id        	
	 * @param string $type        	
	 */
	function retrievefile($id, $type) {
		$contents = FileManager::retrievefile_NFP ( $id, $type );
		
		$encription = new Encryption ( '87!#$%/&&)=/lkhnLKH' );
		
		echo $encription->encrypt ( $contents );
	}
}	