<?php
require_once "utils.php";

/**
 *
 * Main
 *
 * Responsible for handling MVC requests and navigation
 * Performs Navigation to screens and contexts
 *
 * @author balexandre - Advantis
 * @version 1.0.1
 * @package Base
 *         
 */
class main {
	
	/**
	 * constructor
	 */
	function main() {
		
	}
	
	/**
	 * loader
	 */
	public function load_a() {
		$context = 'index';
		$action = 'index';
		self::clean_input();
		if ($_SERVER ['REQUEST_URI']) {
			
			$toparse = "";
			if (__SITEBASE != "" && __SITEBASE != "/")
				$toparse = str_replace ( __SITEBASE . "/", "", $_SERVER ['REQUEST_URI'] );
			else {
				$toparse = preg_replace ( "/\//", "", $_SERVER ['REQUEST_URI'], 1 );
			}
			
			$params = explode ( "/", $toparse );
			
			if (count ( $params ) == 1) {
				
				$context_and_args = explode ( "?", $params [0] );
				
				if ($context_and_args [0])
					$context = $context_and_args [0];
			} else {
				
				if ($params [0]) {
					$context = $params [0];
				}
				
				if ($params [1]) {
					
					$action_and_args = explode ( "?", $params [1] );
					
					$action = $action_and_args [0];
				}
			}
		}
		require_once 'context/class-' . $context . '.php';
		
		if ($context != 'login')
			Session::check_active ();
		
		Session::set_contextname ( $context );
		
		// check user authorization to access context
		
		self::check_authorization ( $context );
		
		$class_name = 'context_' . $context;
		
		$context_class = new $class_name ();
		
		$context_class->$action ();
		
		
	}
	
	/**
	 * validates session is valid.
	 * If not requests login.
	 */
	function check_auth_session() {
		Session::set_URI ( $_SERVER ['REQUEST_URI'] );
		
		if (! Session::get_user ()->username) {
			header ( "Location: " . __LOGINPAGE );
			exit ();
		} else {
			return;
		}
	}
	function check_authorization() {
		if (Session::get_contextname () != 'index' && Session::get_contextname () != 'login' && Session::get_contextname () != 'usersettings' && Session::get_contextname () != 'alerts') {
			
			if (Authorization::context_access_mode () == __ACCESS_FORBIDDEN) {
				
				header ( "Location: " . __SITEBASE );
			}
		}
	}
	
	/**
	 * clean input vars
	 */
	 
	function clean_input(){
		/*
		self::clean_array($_REQUEST); //clean $_REQUEST vars
		
		self::clean_array($_POST);  //clean $_POST vars
		
		self::clean_array($_GET);   //clean $_GET vars
		*/
		$_REQUEST = self::clean_array($_REQUEST); //clean $_REQUEST vars
		
		$_POST = self::clean_array($_POST);  //clean $_POST vars
		
		$_GET = self::clean_array($_GET);   //clean $_GET vars
		
	}
	
	/*
	function clean_array(&$req){
		if (is_array($req)){
			echo "->>>";print_r($req);
			foreach($req as $key =>$val){
				if(is_array($req[$key])){
					$req[$key] = self::clean_array($req[$key]);
				}
				else 
				{
					$req[$key] = htmlspecialchars($val, ENT_QUOTES | ENT_HTML401, 'UTF-8');
				}
					
				
				error_log($req[$key]);
			}
		}
		exit();
	}
	*/
	
	function clean_array($req){
		if (is_array($req)){
		
			foreach($req as $key =>$val){
				if(is_array($req[$key])){
					
					$req[$key] = self::clean_array($req[$key]);
				}
				else 
				{
					$req[$key] = htmlspecialchars($val, ENT_QUOTES | ENT_HTML401, 'UTF-8');
				}
				
				error_log($req[$key]);
			}
		}
		
		return $req;
	}
	
	
	
	
	
}
?>