<?php
require_once "password.php";
require_once "jsonRPCClient.php";
require_once "jsonRPCServer.php";

/**
 * dump and exit
 *
 * @param unknown $obj        	
 */
function dump_stop($obj) {
	if (__DEBUG) {
		echo "<pre>";
		print_r ( $obj );
		echo "</pre>";
		exit ();
	}
}

/**
 * dump
 *
 * @param unknown $obj        	
 */
function dump($obj) {
	if (__DEBUG) {
		echo "<pre>";
		print_r ( $obj );
		echo "</pre>";
	}
}

/**
 * Dump to php log file error from system errors
 *
 * @param string $context        	
 * @param string $action        	
 * @param string $error_msg        	
 */
function dump_errorlog($context, $action, $error_msg) {
	error_log ( __NAME . " error - " . $contextname . "/ " . $action . ": " . $error_msg, 0 );
}

/**
 * Reroute function to recover from exceptions
 *
 * @param string $context        	
 * @param string $action        	
 * @param string $error_msg        	
 */
function goto_errorPage($context, $action, $error_msg) {
	dump_errorlog ( $context, $action, $error_msg );
	
	header ( 'Location:' . __SITEBASE );
	exit ();
}

/**
 * debug
 * 
 * @param unknown $val
 */
function debug($val) {
	if (__DEBUG)
		echo $val;
}

/**
 * return layout for error display
 *
 * @param string $msg        	
 * @param string $rsp
 *        	String to concat return string
 * @return string
 */
function getError($msg, $rsp = '') {
	return $rsp .= ((strlen ( $rsp ) > 0) ? "<BR>" : "") . "<strong>" . R ( "error" ) . "</strong> " .R ( $msg ) ;
}

/**
 * return layout for notifications display
 *
 * @param string $msg        	
 * @param string $rsp
 *        	String to concat return string
 * @return string
 */
function getNotification($msg, $rsp = '') {
	return $rsp .= ((strlen ( $rsp ) > 0) ? "<BR>" : "") . "<strong>" . R ( "notice" ) . "</strong> " .  R ( $msg ) ;
}

/**
 * return layout for sucess messages display
 *
 * @param string $msg        	
 * @param string $rsp
 *        	String to concat return string
 * @return string
 */
function getSuccess($msg, $rsp = '') {
	return $rsp .= ((strlen ( $rsp ) > 0) ? "<BR>" : "") . "<strong>" . R ( "success" ) . "</strong> " .  R ( $msg ) ;
}

/**
 * sets error message in context pvars
 *
 * @param Object $context        	
 * @param string $rsp        	
 */
function setError(&$context, $rsp) {
	$context->data ['pvars'] ['message'] = $rsp;
}

/**
 * sets Notification in session hash for return responses
 *
 * @param string $message        	
 * @param Notification::TYPE $type        	
 */
function setNotification($message, $type = Notification::TYPE_OK) {
	SESSION::add_notification ( new Notification ( $message, $type ) );
}

/**
 * returns all notifications from session hash
 *
 * @return Ambigous <multitype:, NULL>
 */
function getNotifications() {
	return SESSION::get_notifications ();
}

/**
 * js debug
 * 
 * @param unknown $val
 */
function jsdebug($val) {
	echo "<script>";
	echo "alert('" . $val . "')";
	echo "</script>";
}

/**
 * return description for id for session language
 * 
 * @param unknown $id
 * @return string
 */
function D($id) {
	if (! Session::get_language_descriptions ( $id ))
		return "[" . $id . "]";
	else
		return Session::get_language_descriptions ( $id );
}

/**
 * return resource for code for session language
 * 
 * @param unknown $code
 * @return string
 */
function R($code) {
	if (! Session::get_language_resources ( $code )) {
		
		// insert for translation
		$em = new EntityManager ( "resources" );
		
		$r = $em->load ( 'code=?', array (
				$code 
		) );
		
		if (! $r [0]) {
			
			$obj = new stdClass ();
			
			$obj->code = $code;
			
			$obj->languageid = __DEFAULTLANG;
			
			$em->create ( $obj );
		}
		//
		
		return "[" . $code . "]";
	} else
		return Session::get_language_resources ( $code );
}

/**
 * val
 * 
 * @param unknown $obj
 * @param unknown $var
 * @return unknown|string
 */
function val($obj, $var) {
	if (! $obj->$var) {
		if ($_POST [$var]) {
			return $_POST [$var];
		} else {
			return '';
		}
	} else {
		return $obj->$var;
	}
}

/**
 * converts to timestamp to datetime
 * 
 * @param unknown $timestamp
 * @return unknown
 */
function to_datetime($timestamp) {
	$date = date_create ();
	date_timestamp_set ( $date, $timestamp );
	$datetime = date_format ( $date, 'Y-m-d H:i:s' );
	
	return $datetime;
}

/**
 * prints fields data
 * 
 * @param unknown $val
 * @param unknown $type
 */
function print_field($val, $type) {
	switch ($type) {
		
		case "boolean" :
			if ($val)
				echo '<i class="glyphicon glyphicon-ok"></i>';
			else
				echo "-";
			break;
		case "date" :
			if ($val)
				echo date ( "Y-m-d", $val );
			break;
		default :
			echo $val;
	}
}

/**
 * Get Records ID  
 * 
 * @param unknown $inArray
 * @param string $startTag
 * @return multitype:
 */
function get_ck_list_ids($inArray, $startTag = 'ck') {
	$retArr = array ();
	foreach ( $inArray as $key => $value ) {
		
		$pieces = explode ( "_", $key );
		if ($pieces [0] == $startTag) {
			if (! in_array ( $pieces [1], $retArr )) {
				array_push ( $retArr, $pieces [1] );
			}
		}
	}
	
	return $retArr;
}

?>