<?php 
/**
 * Screen clusterdetail\index
 * @version 1.0.1
 * @package Backend\Clusters
 * 
*/

require_once 'app/class-lov-manager.php';
$detail = $this->data['item'];
$list = $this->data['list'];
$bakurl =  $this->data['bakkey'];
$navurl = $this->data['navkey'];
$listStates = $this->data['states'];

$newRecordsetEnabled = false;
$countMemberDuplicates = 0;

$lovmanager = new LovManager();
$prioritylist = $lovmanager->getLov_Priority();
$clusterstatuslist = $lovmanager->getLov_ClusterStatus();
$recordmemberStat = $lovmanager->getLov_ClusterMemberStatus();
$recordstatuslist = $lovmanager->getLov_RecordStatus();
$detectionlist = $lovmanager->getLov_DetectionProcess();

$simpleDetectionlist = array();
foreach ($detectionlist as $lc){
	$simpleDetectionlist[$lc->id] = $lc->descriptioncode;
}

$simpleMemberStatusList = array();
foreach ($recordmemberStat as $lc){
	$simpleMemberStatusList[$lc->id] = $lc->descriptioncode;
}

$simpleStatusList = array();
foreach ($recordstatuslist as $lc){
	$simpleStatusList[$lc->id] = $lc->descriptioncode;
}
?>
<div class="row" >
<div class="col-lg-12" >
            <h3><?= R('page_title_nfp_clusterdetail') ?></h3>
            <p>&nbsp;</p>
			<?php $this->load('common/message',$this) ?>
            
             <form class="form-inline" role="form" id="formcluster" name="formcluster" onsubmit="return validate_checks();"  method="post" action="<?= __SITEBASE ?>/clusterdetail/savecluster">
             <input type="hidden" id="tainted" name="tainted" value="0"></input>
             <input type="hidden" id="retnav" name="retnav" value="clusterdetail"></input>
             <input type="hidden" id="nav_backpost" name="nav_backpost" value="1"></input>
             <input type="hidden" id="cid" name="cid" value="<?=$detail->id ?>"></input>
             <div class="panel panel-default">
		         <div class="panel-body">
			         	<div class="form-group">
			          	<?= R('label_type') ?>:
			          	<b><?= D($simpleDetectionlist[$detail->creationtypecodeid]) ?></b>	
					   </div>
					   <div class="form-group">
					   <?= R('label_priority') ?>:
					   <select name="priority" class="form-control">
					  <?php  foreach($prioritylist as $item) { ?>
					   		<option value="<?= $item->id ?>" <?= ($detail->prioritycodeid == $item->id) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>					   
					   </select>
					  </div>
					   <div class="form-group">
					  <?= R('label_date') ?>:
					 	<b><?= substr($detail->creationdate,0,10) ?></b>
					  </div>
					  <div class="form-group">
					  <?= R('label_status') ?>:
					  <select name="clusterstatus" class="form-control">
					  <?php  foreach($listStates as $item) { ?>
					   		<option value="<?= $item->to_statecode_id ?>" <?= ($detail->statuscodeid == $item->to_statecode_id) ? "selected" : "" ?>><?= D($item->to_statecode__description) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_description') ?>
					   <textarea id="annotation" name="annotation" class="form-control" cols="80" rows="2"><?= $detail->annotation ?></textarea> 
					  </div>
	             </div>
             </div>
            
            <div class="panel" style="margin-top:20px;">
	             <div class="panel panel-default">
			         <div class="panel-body">
			        	 
			           	 <div class="table-responsive" >
				              <table class="table table-hover table-striped tablesorter">
				                <thead>
				                  <tr>
				                  	<th></th>
				                    <th class="header"><?= R('label_UID') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_type') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_recordset') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_organisation') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_recordstatus') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_recordmember') ?> <i class="fa fa-sort"></i></th>
				                  </tr>
				                </thead>
				                <tbody>
				                <?php foreach($list as $line) { ?>
				                 <tr class="annotation" title="<?=$line->responserecords_annotation ?>">
				                    <td><input name="ck_<?= $line->responserecords_id ?>" type="checkbox" <?= ($_POST['ck_'.$line->responserecords_id] != null)? " checked " :"" ?>></td>
				                    <td><a href="<?= __SITEBASE ?>/recorddetail?uid=<?= $line->responserecords_id ?>&<?=$navurl ?>"><?= $line->responserecords_id ?></a></td>
				                    <td><?= ($line->responserecords_statisticaltypeid == __STATISTICAL_TYPE_TRAFFICKERS) ? D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) : D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></td>
				                    <td><a href="<?= __SITEBASE ?>/recordconsolidation?uid=<?= $line->responserecords_recordsetid ?>&<?=$navurl ?>"><?= $line->responserecords_recordsetid ?></a></td>
				                    <td><?= $line->organisations_internationalname ?></td>
				                    <td><?= D($simpleStatusList[$line->responserecords_statuscodeid]) ?></td>
				                    <td><select name="cmstatus_<?=$line->clustermembers_id ?>" class="form-control">
								  	  <?php  foreach($line->listStatus as $item) { ?>
								   		<option value="<?= $item->to_statecode_id ?>" <?= ($item->to_statecode_id == $line->clustermembers_statuscodeid) ? " SELECTED " : "" ?>><?= D($item->to_statecode__description) ?></option> <!-- clustermembers_statuscodeid -->
								   <?php }; ?>
								   </select></td>
				                 </tr>
				               <?php if ($line->clustermembers_statuscodeid == __CLUSTER_MEMBER_STATUS_DUPLICATE)  { $countMemberDuplicates +=1;} 
									}
									if ($countMemberDuplicates >= 2 && $detail->statuscodeid == __CLUSTER_STATUS_CONFIRMED) {
										$newRecordsetEnabled = true;
									}
				               ?>
				                </tbody>
				              </table>
			              </div>
		              </div>
	              </div>
            </div>
           <div class="form-group">
			    <button style="padding-left:20px;" type="submit" onclick="toggleAction('compare')" class="btn btn-default checkboxdependent" ><?=R('label_compare') ?></button>
				<button style="padding-left:20px;" type="submit" onclick="toggleAction('recordset')" class="btn btn-default checkboxdependent" <?= (!$newRecordsetEnabled)? " disabled" : "" ?>><?=R('label_addrecordset') ?></button>				
				<button style="margin-left:100px;" type="submit" class="btn btn-default"><?=R('label_save') ?></button>
				<?php if (isset($bakurl)) { ?>
					<a href="<?= __SITEBASE ?>/<?= $bakurl ?>" class="btn btn-default"><?=R('label_cancel') ?></a>
					<?php } ?>

			</div>
			</form>
		</div>
</div>
  <script>
function toggleAction(action) {

	$('#tainted').val('1');
	
	if (action == 'recordset')
	{
		$('#formcluster').attr('action','<?= __SITEBASE ?>/clusterdetail/newrecordset');
	}
	if (action == 'compare')
	{
		$('#formcluster').attr('action','<?= __SITEBASE ?>/comparerecords/');
	}
}

function validate_checks() {

	if ($('#tainted').val() == '1')
	{
		if (1==1) {
			return true;
		}
		else {
			$('#tainted').val('0');
		 	$("#formcluster").attr("action",'<?= __SITEBASE ?>/clusterdetail/savecluster');
			return false;
		}
	}
}


//enable and disable buttons dependent off checkboxes
$(document).ready(function() {
	$(".checkboxdependent").prop('disabled', true);

	$("[type=checkbox]").bind("click",function(){
	
		if($("[type=checkbox]:checked").length == 0) {
			$(".checkboxdependent").prop('disabled', true);
		} else {
			$(".checkboxdependent").prop('disabled', false);;
		}
		
	});
});
//-----------------------------------------------------------

 </script>  