<?php
/**
 * Screen efpcollect\index
 * @version 1.0.1
 * @package Backend\DataSets
 * 
*/
require_once 'app/class-lov-manager.php';

$organisation_list = $this->data ['organisation_list'];
$list = $this->data ['list'];
$navurl = $this->data ['navkey'];
$fileoklist = $this->data ['fileoklist'];

//print_r($list);
// print_r($_POST);

$lovmanager = new LovManager ();
$recordstatuslist = $lovmanager->getLov_RecordStatus ();

$simpleStatusList = array ();
foreach ( $recordstatuslist as $lc ) {
	$simpleStatusList [$lc->id] = $lc->descriptioncode;
}

?>
<div class="row">
	<div class="col-lg-12">
		<h3><?= R('page_title_efp_collectdata') ?></h3>
		<p>&nbsp;</p>
			<?php $this->load('common/message',$this)?>
            
             <form class="form-inline" role="form" name="formcolefp"
			id="formcolefp" onsubmit="return validate();" method="post"
			action="<?= __SITEBASE ?>/efpcollect">
			<input type="hidden" id="tainted" name="tainted" value="0"></input> <input
				type="hidden" id="retnav" name="retnav" value="efpcollect"></input>
			<div class="panel panel-default">
				<div class="panel-body">
					<div class="form-group">
						<?=  R('label_organization') ?>:
				    	<select permissions="false" class="form-control" name="organisationid" id="organisationid">
							<option value="" style="display: none;"><?= R("label_please_select_dropdown")?>
				    		<?php foreach ( $organisation_list as $org ) {?>
									<option
										<?= ($_POST['organisationid'] == $org->id) ? "selected" : ""?>
										value="<?= $org->id ?>"><?= $org->internationalname ?></option>
				    		<?php 	} ?>
				    	</select>
					</div>
					<div class="form-group">
					   <?= R('label_from') ?>:
					   <input permissions="false" type="text" name="fromdate" id="fromdate" value="<?= $_POST['fromdate'] ?>" class="form-control"	placeholder="">
					</div>
					<div class="form-group">
					   <?= R('label_to') ?>:
					   <input permissions="false" type="text" name="todate" id="todate" value="<?= $_POST['todate'] ?>" class="form-control" placeholder="">
					</div>
					<div class="form-group">
					  <?= R('label_type') ?>:
					  <select permissions="false" name="type" class="form-control">
							<option value="<?= __STATISTICAL_TYPE_VICTIMS ?>"
								<?= ($_POST['type'] == __STATISTICAL_TYPE_VICTIMS || $_POST['type']== "") ? "selected" : "" ?>><?= D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></option>
							<option value="<?= __STATISTICAL_TYPE_TRAFFICKERS ?>"
								<?= ($_POST['type'] == __STATISTICAL_TYPE_TRAFFICKERS ) ? "selected" : "" ?>><?= D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) ?></option>
						</select>
					</div>
				</div>
			</div>
			<button permissions="false" type="submit" class="btn btn-default"><?=R('label_filter') ?></button>
			<a href="#" btnaction="true" class="btn btn-default" onclick="clean();">
			<?= R("label_clear") ?></a>

			<div class="panel" style="margin-top: 20px;">
				<div class="panel panel-default">
					<div class="panel-body">
						<div class="table-responsive">
							<table id="table1" class="table table-hover table-striped tablesorter">
								<thead>
									<tr>
										<th class=""></th>
										<th class="header"><?= R('label_name') ?> <i class="fa fa-sort"></i></th>
										<th class="header"><?= R('label_type') ?> <i class="fa fa-sort"></i></th>
										<th class="header"><?= R('label_date') ?> <i	class="fa fa-sort"></i></th>
										<th class="header"><?= R('label_period') ?> <i	class="fa fa-sort"></i></th>
										<th class="header"><?= R('label_organization') ?> <i class="fa fa-sort"></i></th>
										<th class="header"><?= R('label_status') ?> <i class="fa fa-sort"></i></th>
									</tr>
								</thead>
								<tbody>
				                <?php foreach($list as $line) { ?>
				                 <tr class="annotation" title="<?=$line->annotation ?>">
				                 	<td>
				                 	<?php if (in_array($line->id,$fileoklist)) {?>
				                 		<a href="" onclick="window.open('<?= __SITEBASE ?>/setdetail/downloadfile?id=<?= $line->id ?>');return false;"><i class="fa fa-paperclip"></i></a>
				                 	<?php } ?>
				                 	</td>
				                 	<td><a href="<?= __SITEBASE ?>/setdetail?uid=<?= $line->id ?>&<?=$navurl ?>"><?= $line->id ?></a></td>
									<td><?= ($line->statisticaltypeid == __STATISTICAL_TYPE_TRAFFICKERS) ? D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) : D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></td>
									<td><?= $line->setdate ?></td>
									<td><?= $line->fromperiod.'-'.$line->toperiod ?></td>
									<td><?= $line->organisationname ?></td>
									<td><?= D($simpleStatusList[$line->statuscodeid]) ?></td>
									</tr>
				               <?php }?>
				                </tbody>
							</table>

						</div>

					</div>

				</div>

				<div>
			    	<select class="form-control" name="syncorganisationid" id="syncorganisationid">
				    		<?php foreach ( $organisation_list as $org ) {?>
									<option
										<?= ($_POST['syncorganisationid'] == $org->id) ? "selected" : ""?>
										value="<?= $org->id ?>"><?= $org->internationalname ?></option>
				    		<?php 	} ?>
			    	</select>		
				
				<a href="#" permissions="true" style="padding-left: 20px;" onclick="openSyncModal();" class="btn btn-default"><?=R('label_sync') ?></a>
				</div>	
		</div>
		</form>
	</div>
</div>
<div class="modal" id="syncModal" data-backdrop="static" >
	<div class="modal-dialog" style="top:200px;width:30%;">
      <div class="modal-content" >
        <div class="modal-header">
          <h4 class="modal-title"><?= __NAME ?></h4>
        </div>
        <div class="modal-body" style="text-align:center;height:170px">
        	<p></p>
        	<?= R('text_efp_sync_wait') ?>
        	<p></p>
        	<img src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/images/wait.gif" style="height:100px">
        	<iframe id="syncframe" style="border:0;width:100%;height:0px"></iframe>
        </div>
      </div>
    </div>
</div>
<script>
 $(document).ready(function() {
	    $('#fromdate').Zebra_DatePicker({default_position:"below",readonly_element:false});
	    $('#todate').Zebra_DatePicker({default_position:"below",readonly_element:false});
});

function clean() {

	$('#fromdate').val('');
	$('#todate').val('');
	$('select option:selected').removeAttr('selected');
}



function validate() {

	if ($('#tainted').val() == '1')
	{
		if (1==1) {
			return true;
		}
		else {
			$('#tainted').val('0');
		 	$("#formcolefp").attr("action",'<?= __SITEBASE ?>/efpcollect');
			return false;
		}
	}
}


function openSyncModal() {
	orgid=$("#syncorganisationid").val();

	if (!isNaN(orgid) && orgid != 0) {
		url = '<?= __SITEBASE ?>/efpcollect/sync?orgid='+orgid;
		$('#syncframe').attr('src',url);
		$('#syncModal').modal({show:true});
	}
}


 </script>
