<?php
/**
 * Screen reports\index
 * @version 1.0.1
 * @package Backend\Reports
 * 
*/
$title = "Reports";
$context = $this->data["contextname"];
$list = $this->data['list'];
function UniqueItems($array,$key)
{
   $temp_array = array();
   foreach ($array as &$v) {
       if (!isset($temp_array[$v[$key]]))
       $temp_array[$v[$key]] =&$v;
   }
   $array = array_values($temp_array);
   return $array;
}

foreach ( $list as $item=>$rn ) 
    {
        $lista []= array(
            'reportid'=>(int)$rn->reportid, 
            'indicatorid'=>(int)$rn->indicatorid,
            'reporttype'=>$rn->reporttype, 
            'reportname'=>$rn->reportname,
            'languageid'=>(int)$rn->languageid, 
            'finalrelease'=>(int)$rn->finalrelease,
            'publstatus'=>$rn->publstatus,
            'embargodate'=>$rn->embargodate, 
            'lastupdate'=>$rn->lastupdate,
            'firstyear'=>(int)$rn->firstyear, 
            'lastyear'=>(int)$rn->lastyear,
            'indicatordesc'=>$rn->indicatordesc, 
            'statisticaltypeid'=>(int)$rn->statisticaltypeid,
            'unit'=>$rn->unit, 
            'urlmetadata'=>$rn->urlmetadata
            );
    
        
    }
$resultList = UniqueItems($lista, 'reportid'); //set unique item by reportID
$countries = $this->data['countries'];
$language_id = Session::get_language()->id;
$grupo = Session::get_activerole()->role_code;
?>
<style>
    #page_reports {
        display: none;
    }

</style>
<div id="page_reports" class="row" >
    <div class="col-md-12" >
            <h3><?= R('page_title_reports') ?></h3>
            <p>&nbsp;</p>
			<?php  $this->load('common/message',$this) ?>
            <form id="formReports" name="formReports" class="form-inline" method="post" action="<?= __SITEBASE ?>/reports/showreport">
		       <div class="panel panel-default">
		        <div class="panel-body">
                            <div class="row">
                                 <div class="form-group col-md-12">
                                <label for="report"><?= R('label_report') ?>:</label>
                                <select name="reports" id="reports" class="form-control">
                                    <?php 
                                    foreach ( $resultList as $rp=>$resl ) {?>
                                            <option value="<?= $resl['reportid'] ?>"><?= $resl['reportname'] ?></option>
                                    <?php } ?>
                                </select>
                                  </div>
                                
                                 <div class="form-group col-md-7">
                                <label for="country"><?= R('label_country') ?>:</label>
                                <select name="country" id="country" class="form-control">
                                    <?php foreach ( $countries as $item=>$country ) {?>
                                            <option value="<?= $country->countryid ?>"><?= $country->valuetext ?></option>
                                    <?php } ?>
                                </select>
                                </div>
                                <?php if($grupo==='OM'){?>
                                    <div class="form-group col-md-5">
                                <label><?= R('label_publication_status') ?></label>
                                  <select name="pubstatus" id="pubstatus" class="form-control">
                                    <?php 
    
                                    foreach ( $list as $item=>$rn ) {
                                        $pubstat []= array('status'=>$rn->publstatus, 'type'=>(int)$rn->finalrelease);
                                    }
                                     $result_status = array_unique($pubstat, SORT_REGULAR);
                                     foreach ( $result_status as $res=>$pbs ) {
                                         if((int)$pbs['type']===1){?>
                                    <option value="<?= $pbs['type'] ?>"><?= $pbs['status']  ?></option>
                                    <?php 
                                         }
                                         } ?>
                                    
                                </select>
                                    
                               
                                </div>
                                <?php }else {?>
                                
                                <div class="form-group col-md-5">
                                <label><?= R('label_publication_status') ?>:</label>
                                <select name="pubstatus" id="pubstatus" class="form-control">
                                    <?php 
    
                                    foreach ( $list as $item=>$rn ) {
                                        $pubstat []= array('status'=>$rn->publstatus, 'type'=>(int)$rn->finalrelease);
                                    }
                                     $result_status = array_unique($pubstat, SORT_REGULAR);
                                     foreach ( $result_status as $res=>$pbs ) {?>
                                    <option value="<?= $pbs['type'] ?>"><?= $pbs['status']  ?></option>
                                    <?php } ?>
                                    
                            </select>

                                </div>
                                 <?php } ?>
                                <div class="form-group col-md-7">                   
                                     <label><?= R('label_indicator_description') ?>:</label>
                                      <?php foreach ( $resultList as $rp=>$resl ) {?>
                                        <span class="report_text report_<?= $resl['reportid'] ?>"><?= $resl['indicatordesc'] ?></span>
                                       <?php } ?>  
                               </div> 
                                <div class="form-group col-md-2">
                               
                                     <label><?= R('label_unit') ?>:</label>
                                     <?php foreach ( $resultList as $rp=>$resl ) {?>             
                                     <span id="span_unit" class="report_text report_<?= $resl['reportid'] ?>"><?= $resl['unit'] ?></span>
                                    <?php } ?>
                                </div> 
                            </div>
                            
                            <div class="row">
                               
                                
                                 <div class="form-group col-md-3">
                                <label><?= R('label_last_update_data') ?>:</label>
                                <span id="update_date">00000</span>
                                
                                </div>
                                
                                <div class="form-group col-md-4">
                                <label><?= R('label_date_avail_overall') ?>:</label>
                                <span id="first_year"></span>-<span id="last_year"></span>
                               
                                </div>
                                
                                 <div class="form-group col-md-2">
                                <label><?= R('label_embargo') ?>:</label>
                             <?php foreach ( $resultList as $rp=>$resl ) {?>
                                     <span id="embargo_period" class="report_text report_<?= $resl['reportid'] ?>"><?= $resl['embargodate'] ?></span>
                                <?php } ?>
                                 </div>
                            </div>
                            
                            <div class="row">
                                
                                                              
                                 <div class="form-group col-md-6">
                                <label><?= R('label_year_from') ?>:</label>
                                <select id="year_ini" name="year_ini" class="form-control">
                                    <?php foreach ( $list as $item=>$rn ) {
                                        $min_year []= $rn->firstyear;
                                        $min = min($min_year);
                                        $ano_minimo = range(date('Y'), $min);
                                         } ?> 
                                    <?php foreach ($ano_minimo as $m_ano) {
                                            echo '<option value="'.$m_ano.'">'.$m_ano.'</option>';
                                          }?>
                                </select>
                            
                                <label><?= R('label_year_to') ?>:</label>
                                <select name="year_fin" id="year_fin" class="form-control">
                                    <?php foreach ( $list as $item=>$rn ) {
                                        $max_year []= $rn->lastyear;
                                        $max = min($max_year);
                                        $ano_max = range(date('Y'), $max);
                                         } ?> 
                                    <?php foreach ($ano_max as $max_ano) {
                                            echo '<option value="'.$max_ano.'">'.$max_ano.'</option>';
                                          }?>

                                </select>
                            </div>  

                            </div>
                          
                            <div class="row">
                                <div class="form-group col-md-6">
                                <label><?= R('label_output_file') ?>:</label>
                                <select name="output" id="output" class="form-control">
                                    <option value="pdf">PDF</option>
                                    <option value="xls">XLS</option>
                                </select>
                                  
                                 </div>
                                
                                <div class="form-group col-md-3 pull-right">
                                       <?php foreach ( $resultList as $rp=>$resl ) {?>
                                    <span class="report_text report_<?= $resl['reportid'] ?>">
                                       <a href="<?= $resl['urlmetadata'] ?>" target="_blank"><?= R('label_report_metadata') ?></a>
                                    </span>
                                     <?php } ?> 
                                </div>

                            </div>

	              </div>
            </div>
                <button type="submit" id="submitReport" class="btn btn-default"><?= R('label_run') ?></button>
                <div class="row">
                        <input type="hidden" id="lang_id" name="lang_id" value="<?= $language_id ?>">
                       
                        <span id="tipo_report">
                        <?php foreach ( $list as $item=>$rn ) {?>
                            <input class="report_text report_<?= $rn->reportid ?>" type="hidden" id="report_type" name="report_type" value="<?= $rn->reporttype ?>">
                         <?php } ?>  
                        </span>
                        
                         <span id="indicador">
                     <?php foreach ( $list as $item=>$rn ) {?>
                             <input class="report_text report_<?= $rn->reportid ?>" type="hidden" id="indicator_id" name="indicator_id" value="<?= $rn->reportid ?>">
                        <?php } ?>  
                     </span>
                
                    
                     <?php foreach ( $list as $item=>$rn ) {
                          $date = explode(" ",$rn->lastupdate);
                         ?>
                        <input class="report_text report_<?= $rn->reportid ?>" type="hidden" id="<?php echo 'updated'.(int)$rn->finalrelease; ?>" value="<?= $date[0] ?>">
                       
                        <input class="report_text report_<?= $rn->reportid ?>" type="hidden" id="<?php echo 'status'.(int)$rn->finalrelease; ?>" value="<?= $rn->lastyear ?>">
                        <?php } ?>  
                    
                      <input type="hidden" id="indicatorID" name="indicatorID" value="">
                      <input type="hidden" id="reportType" name="reportType" value="">
                      <input type="hidden" id="finalRelease" name="finalRelease" value="">
                </div>
                
            </form>
          
                   
           </div>
     </div>      
           


   <script type="text/javascript">
   $( document ).ready(function() {
        
        $("#page_reports").fadeIn(100);
        $('span.report_text').hide();
        $('.report_' + $("#reports").val()).addClass('active');
        $('.report_' +  $("#reports").val() + '.active').show();
        $('#reportType').val($("#tipo_report").find('.active').val());
        $('#indicatorID').val($("#indicador").find('.active').val()); 
        $('#finalRelease').val($("#pubstatus").val());
        $('#first_year').html($('#'+'status'+$("#pubstatus option:selected").val()+'.active').val()); 
        $('#last_year').html($('#'+'status'+$("#pubstatus option:selected").val()+'.active').val()); 
        $('#update_date').html($('#'+'updated'+$("#pubstatus option:selected").val()+'.active').val()); 
        $( "#pubstatus" ).change(function() {
            $('#finalRelease').val($("#pubstatus").val());
            $('#first_year').html($('#'+'status'+$("#pubstatus option:selected").val()+'.active').val()); 
            $('#last_year').html($('#'+'status'+$("#pubstatus option:selected").val()+'.active').val());
            $('#update_date').html($('#'+'updated'+$("#pubstatus option:selected").val()+'.active').val()); 
          //alert($('#'+'status'+$("#pubstatus option:selected").val()+'.active').val());   
        });
        $( "#reports" ).change(function() {
           
                $('span.report_text').hide();
                $('.report_text').removeClass('active');    
                $('.report_' +  $("#reports").val()).addClass('active');
                $('.report_' + $(this).val()).show();
                $('#indicatorID').val($(this).val());
                $('#reportType').val($("#tipo_report").find('.active').val());
                $('#indicatorID').val($("#indicador").find('.active').val());
               
        });

    });

    </script>
