<?php
/**
 * Screen sidebar
 * @version 1.0.1
 * @package Base
 * 
*/


require_once 'app/class-user-manager.php';
require_once 'app/class-alert-manager.php';
$usermanager = new UserManager();
$alertmanager = new AlertManager();

$userroles = $usermanager->get_user_roles();
$activeuserrole = $usermanager->get_active_userrole();
$useralerts = $alertmanager->user_show_alerts();              

?>
<!-- Sidebar -->
<nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
	<!-- Brand and toggle get grouped for better mobile display -->
	<div class="navbar-header">
		<button type="button" class="navbar-toggle" data-toggle="collapse"
			data-target=".navbar-ex1-collapse">
			<span class="sr-only">Toggle navigation</span> <span class="icon-bar"></span>
			<span class="icon-bar"></span> <span class="icon-bar"></span>
		</button>
		<a class="navbar-brand" href="<?= __SITEBASE ?>"><?= __NAME ?> - <?= Session::get_org()->internationalname ?></a>
	</div>

	<!-- Collect the nav links, forms, and other content for toggling -->
	<div class="collapse navbar-collapse navbar-ex1-collapse">

		<ul class="nav navbar-nav side-nav">
			<?php if (Authorization::view_access('settings') || 
					  Authorization::view_access('languages')) { ?>
			<li class="dropdown"><a href="#" class="dropdown-toggle"
				data-toggle="dropdown"> <i class="fa fa-wrench"></i> <?= R('menu_general_settings') ?> <b
					class="caret"></b></a>
				<ul class="dropdown-menu">
					<?php if (Authorization::view_access('settings')) { ?>
					<li>
					<a href="<?=__SITEBASE ?>/settings"><?= R('menu_settings') ?> </a>
					</li>
					<?php } ?>
					<?php if (Authorization::view_access('languages')) { ?>
					<li>
					<a href="<?=__SITEBASE ?>/languages/list_resources"><?= R('menu_translate') ?> </a>
					</li>
					<?php } ?>
				</ul>
			</li>
			<?php } ?>
			<?php if (Authorization::view_access('commonmodel') || 
					  Authorization::view_access('nationalprofile') ||
					  Authorization::view_access('localprofile') ||
					  Authorization::view_access('provisionagreement')) { ?>
			<li class="dropdown"><a href="#" class="dropdown-toggle"
				data-toggle="dropdown"> <i class="fa fa-edit"></i> <?= R('menu_data_agreements') ?> <b
					class="caret"></b></a>

				<ul class="dropdown-menu">
					<?php if (Authorization::view_access('commonmodel')) { ?>
					<li><a href="<?= __SITEBASE ?>/commonmodel"><?= R('menu_view_cm') ?></a></li>
					<?php } ?>
					<?php if (Authorization::view_access('nationalprofile')) { ?>
					<li><a href="<?= __SITEBASE ?>/nationalprofile"><?= R('menu_view_ndp') ?></a></li>
					<?php } ?>
					<?php if (Authorization::view_access('localprofile')) { ?>
					<li><a href="<?= __SITEBASE ?>/localprofile"><?= R('menu_edit_lp') ?></a></li>
					<?php }?>
					<?php if (Authorization::view_access('provisionagreement')) { ?>
					<li><a href="<?= __SITEBASE ?>/provisionagreement"><?= R('menu_edit_dpa') ?></a></li>
					<?php }?>
				</ul>
			</li>
			<?php } ?>
			<?php if (Authorization::view_access('organizations') || 
					  Authorization::view_access('users')
					 ) { ?>
			<li class="dropdown"><a href="#" class="dropdown-toggle"
				data-toggle="dropdown"> <i class="fa fa-users"></i> <?= R('menu_organisations_users') ?> <b
					class="caret"></b></a>
				<ul class="dropdown-menu">
					<?php if (Authorization::view_access('organizations')) { ?>
					<li><a href="<?= __SITEBASE ?>/organizations"><?= R('menu_organisations') ?></a></li>
					<?php } ?>
					<?php if (Authorization::view_access('users')) { ?>
					<li><a href="<?= __SITEBASE ?>/users"><?= R('menu_users') ?></a></li>
					<?php } ?>
				</ul>
			</li>
			<?php } ?>
			<?php if (Authorization::view_access('collectdata') ||
					Authorization::view_access('nfpcollect') || Authorization::view_access('efpcollect') ||
					Authorization::view_access('nfpanalyse') || Authorization::view_access('efpanalyse') ||
			Authorization::view_access('nfppublish') || Authorization::view_access('efppublish') ) { ?>
			<li class="dropdown"><a href="#" class="dropdown-toggle"
				data-toggle="dropdown"> <i class="fa fa-bars"></i> <?= R('menu_data_records') ?> <b
					class="caret"></b></a>
				<ul class="dropdown-menu">
				<?php 
					$userrole = Session::get_activerole();
	 				$menu_data_label = '';
	 				if (Authorization::view_access('collectdata')) {
						switch($userrole->role_code) {
				 		case 'LC':
				 			$menu_data_label = 'menu_collect';
							break;
				 		case 'LA': 
				 			$menu_data_label = 'menu_analyse';
					 		break;
					 	case 'LP':
					 		$menu_data_label = 'menu_publish';
					 		break;
				 		}

				 	 ?>
					<li><a href="<?= __SITEBASE ?>/collectdata"><?= R($menu_data_label) ?></a></li>
					<?php } 
					
				 	if (Authorization::view_access('nfpcollect')) { ?>
						<li><a href="<?= __SITEBASE ?>/nfpcollect"><?= R('menu_collect') ?></a></li>
					<?php }	
				 	if (Authorization::view_access('nfpanalyse')) { ?>
						<li><a href="<?= __SITEBASE ?>/nfpanalyse"><?= R('menu_analyse') ?></a></li>
					<?php } 	
					if (Authorization::view_access('nfppublish')) { ?>
						<li><a href="<?= __SITEBASE ?>/nfppublish"><?= R('menu_publish') ?></a></li>
					<?php } 
					// EFP - menu
					if (Authorization::view_access('efpcollect')) { ?>
						<li><a href="<?= __SITEBASE ?>/efpcollect"><?= R('menu_collect') ?></a></li>
					<?php }	
				 	if (Authorization::view_access('efpanalyse')) { ?>
						<li><a href="<?= __SITEBASE ?>/efpanalyse"><?= R('menu_analyse') ?></a></li>
					<?php } 	
					if (Authorization::view_access('efppublish')) { ?>
						<li><a href="<?= __SITEBASE ?>/efppublish"><?= R('menu_publish') ?></a></li>
					<?php } ?>	
					
					
				</ul>
			</li>
			<?php } ?>
			<?php if (Authorization::view_access('clusters') || 
					  Authorization::view_access('recordsets')
					 ) { ?>
			<li class="dropdown"><a href="#" class="dropdown-toggle"
				data-toggle="dropdown"> <i class="fa fa-tags"></i> <?= R('menu_duplicate_records') ?> <b
					class="caret"></b></a>
				<ul class="dropdown-menu">
					<?php 	
				 	if (Authorization::view_access('clusters')) { ?>
						<li><a href="<?= __SITEBASE ?>/clusters"><?= R('menu_clusters') ?></a></li>
					<?php } 	
					if (Authorization::view_access('recordsets')) { ?>
						<li><a href="<?= __SITEBASE ?>/recordsets"><?= R('menu_recordsets') ?></a></li>
					<?php } ?>	
					
				</ul>
			</li>
			<?php } ?>
                        <?php if (Authorization::view_access('websig') ||
                                    Authorization::view_access('reports') || 
                                    Authorization::view_access('websigservices')) { ?>
			<li class="dropdown"><a href="#" class="dropdown-toggle"
				data-toggle="dropdown"> <i class="fa fa-map-marker"></i> <?= R('menu_websig') ?> <b
					class="caret"></b></a>
				<ul class="dropdown-menu">
                                     <?php if (Authorization::view_access('websig')) { ?>
					<li><a href="<?= __SITEBASE ?>/websig"><?= R('menu_websig') ?></a></li>
                                        <?php } ?>
                                    <?php if (Authorization::view_access('websigservices')) { ?>
					<li><a href="<?= __SITEBASE ?>/websigservices"><?= R('menu_websigservices') ?></a></li>
                                    <?php } ?>
                                        <?php if (Authorization::view_access('reports')) { ?>
					<li><a href="<?= __SITEBASE ?>/reports"><?= R('menu_reports') ?></a></li>
                                        <?php } ?>
				</ul>
			</li>
			<?php } ?>
			<?php if (Authorization::view_access('dataaudit') ||
						Authorization::view_access('securityaudit')) { ?>
			<li class="dropdown"><a href="#" class="dropdown-toggle"
				data-toggle="dropdown"> <i class="fa fa-gear"></i> <?= R('menu_auditing') ?> <b
					class="caret"></b></a>
				<ul class="dropdown-menu">
				<?php if (Authorization::view_access('securityaudit')) { ?>
					<li><a href="<?= __SITEBASE ?>/securityaudit"><?= R('menu_security_audit') ?></a></li>
				<?php } ?>
				<?php if (Authorization::view_access('dataaudit')) { ?>
					<li><a href="<?= __SITEBASE ?>/dataaudit"><?= R('menu_data_audit') ?></a></li>
				<?php } ?>
				</ul>
			</li>
			<?php } ?>
			<li>
				<div style="margin-top:20px;margin-left:30px;padding-bottom:50px;">
					<img style="padding-bottom:14px" src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/images/eurologo.gif">
					<img src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/images/orglogo.gif">
				</div>
			</li>
		</ul>
		
		<ul class="nav navbar-nav navbar-right navbar-user">
			<li class="dropdown user-dropdown">
        	 
              <a href="#" class="dropdown-toggle" data-toggle="dropdown"><?= D($activeuserrole->role_descriptioncode) ?> <i class="fa"></i><b class="caret"></b></a>
             <?php if (count($userroles)>1) {?>
              <ul class="dropdown-menu">
               	<?php for($i=0;$i<count($userroles);$i++) { 
               			if($activeuserrole->roleid != $userroles[$i]->roleid) { ?>
               	
              	<li><a href="<?= __SITEBASE ?>/index/role?id=<?= $userroles[$i]->roleid ?>"><?= D($userroles[$i]->role_descriptioncode) ?></a>
              </li>
                <?php 	}
               		 }	?>
              </ul>
              <?php }?>
            </li>
            <?php 
            $em = new EntityManager("languages");
			$language_list = $em->load("active is true");
            ?>
			<li class="dropdown user-dropdown">
				<a href="#"
				class="dropdown-toggle" data-toggle="dropdown"><i
					class="fa fa-globe"></i> <?= D(Session::get_language()->descriptioncode) ?><b class="caret"></b></a>
				<ul class="dropdown-menu">
				<?php foreach($language_list as $lang) {?>
						<?php if ($lang->id != Session::get_language()->id) { ?>
					  	<li><a href="<?= __SITEBASE ?>/index/lang?id=<?= $lang->id ?>"><?= D($lang->descriptioncode) ?></a></li>
					  	<?php } ?>
                <?php }?>
				</ul>
			</li>
			<li class="dropdown alerts-dropdown"><a href="<?= __SITEBASE ?>/alerts"
				><i class="fa fa-bell"></i>
					<?= R('label_alerts') ?> <span class="badge"><?=$useralerts  ?></span> <b class="caret"></b></a>
			</li>
			<li class="dropdown user-dropdown"><a href="#"
				class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user"></i> <?= html_entity_decode(Session::get_user()->fullname) ?> <b
					class="caret"></b></a> 
				
				<ul class="dropdown-menu">
					<li><a href="<?= __SITEBASE ?>/usersettings"><i
							class="fa fa-wrench"></i> <?= R('user_sesstings') ?></a></li>
					<li><a href="<?= __SITEBASE ?>/index/logout"><i
							class="fa fa-power-off"></i> <?= R('log_out') ?></a></li>
				</ul>
			</li>
			
		</ul>
	</div>
	<!-- /.navbar-collapse -->
	
</nav>
