<?php 
/**
 * Screen users\detail
 * @version 1.0.1
 * @package Backend\Users
 * 
*/

$user = $this->data['user'];
$organisation_list = $this->data['organisation_list'];
$user_roles =  $this->data['user_roles'];
$available_roles =  $this->data['available_roles'];


$bt_status="";
$action = "new"; 

if ($user->id) {
	
	$action = "edit";
        $bt_status= 'readonly="readonly"';
}



?>
<div class="row" >
<div class="col-lg-12" >
<h3><?=R('page_user_management_title') ?></h3>
<div class="panel panel-default">
 <div class="panel-body">
	<h4><?= R('label_new_user') ?></h4>
</div>
</div>
<?php $this->load('common/message',$this) ?>
<div class="panel panel-default">
<div class="panel-body">
	<?php  if ($user->blocked) { ?>
	<div class="col-sm-2"></div>
	 <div class="col-sm-7" >
	 	<p style="text-align:center;padding:10px" class="bg-danger">
		<?= R('text_user_is_blocked') ?>&nbsp;&nbsp;&nbsp;&nbsp;
		<a href="<?= __SITEBASE ?>/users/unblockuser?id=<?=$user->id ?>" class="btn btn-warning" ><?= R('btn_unblock_user') ?></a>
		</p>
	</div>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
     	<?php } ?>
<form id="form1" class="form-horizontal" action="<?= __SITEBASE ?>/users/<?= $action == "new" ? "create" : "save" ?>"  method="post" autocomplete="off">
	<div class="form-group">
    	<label class="col-sm-2 control-label"><?= R('label_fullname') ?>:</label>
    	<div class="col-sm-5">
        	<input type="text" required class="form-control" maxlength="150" name="fullname" placeholder="<?= R('label_fullname') ?>" value="<?= val($user,'fullname') ?>">
        </div>
   	</div>
   	<div id="usernameformgroup" class="form-group">
   		<label class="col-sm-2 control-label"><?= R('label_username') ?>:</label>
   		<div class="col-sm-5">
                    <input id="username"  onchange="javascript:checkuser();" onkeyup="javascript:checkuser();" type="text" required class="form-control" <?= $bt_status;?> maxlength="50" name="username" placeholder="<?= R('label_username') ?>" value="<?= val($user,'username') ?>">
    	</div>
    	<div id="usererror" ></div>
    </div>
	<div class="form-group ">
   		<label class="col-sm-2 control-label"><?= R('label_email') ?>:</label>
   		<div class="col-sm-5">
    		<input type="text" required type="email" maxlength="100" class="form-control" name="email" placeholder="<?= R('label_email') ?>" value="<?= val($user,'email') ?>">
    	</div>
    </div>
    <div class="form-group ">
   		<label class="col-sm-2 control-label"><?= R('label_contact') ?>:</label>
   		<div class="col-sm-5">
    		<input type="text" maxlength="100" class="form-control" name="contact" placeholder="<?= R('label_contact') ?>" value="<?= val($user,'contact') ?>">
    	</div>
    </div>
	<div class="form-group">
   		<label class="col-sm-2 control-label"><?= R('label_organization') ?>:</label>
   		<div class="col-sm-5">
    		<select class="form-control" name="organisationid" id="organisationid" <?= $bt_status;?> onchange="change_roles();">
    		<option value=""  style="display: none;"><?= R("label_please_select_dropdown") ?>
    		<?php 
    		$selectedid = $_REQUEST["organisationid"] ? $_REQUEST["organisationid"] : $user->organisationid;
    		?>
    		<?php foreach($organisation_list as $org) {?>
    			<option <?= $selectedid == $org->id ? "selected" : "" ?> value="<?= $org->id ?>"><?= $org->organisationname ?></option>
    		<?php }?>
    		</select>
    	</div>
    </div>    
    <div class="form-group">
   		<label class="col-sm-2 control-label"><?= R('label_roles') ?>:</label>
   		<div class="col-sm-5">
    		<select multiple class="form-control" name="roles[]" id="roles">
    		<?php foreach($available_roles as $role) {?>
    			<option <?= $user_roles ? (in_array($role->roleid,$user_roles) ? "selected":""):"" ?> value="<?= $role->roleid ?>"><?= D($role->descriptioncode) ?></option>
    		<?php }?>
    		</select>
    	</div>
    </div>    
    <?php if ($action == "edit") { ?>
    <div class="form-group">
    	<label class="col-sm-2 control-label"></label>
   		 <a href="#" class="btn btn-link" id="showpasswordlink" onclick="javascript:$('#showpassword').slideDown();$(this).hide();$('#cancelpasswordlink').show();"><?= R("label_changepassword") ?></a>
   		 <a href="#" style="display:none" class="btn btn-link" id="cancelpasswordlink" onclick="javascript:$('#showpassword').slideUp();$(this).hide();$('#showpasswordlink').show();"><?= R("label_cancel") ?></a>
     </div>
    <div id="showpassword" style="display:none">
    <?php }?>
     <div class="form-group" style="padding-bottom:5px;margin-bottom:5px">
    	<p class="col-sm-2 control-label"></p>
    	<p class="col-sm-5"><?= R('text_password_rules') ?></p>
    </div>
    <div class="form-group ">
    	
    	<label class="col-sm-2 control-label"><?= R('label_password') ?>:</label>
   		<div class="col-sm-5">
    		<input pattern="((?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[@$%!#\?&\*]).{8,100})" maxlength="100" <?=$action == "new" ? "required":"" ?> class="form-control" onchange="javascript:$('#password_changed').val('1');" type="password" name="passwd" placeholder="<?= R('label_password') ?>" value="">
    	</div>
    </div>
     <div class="form-group ">
   		<label class="col-sm-2 control-label"><?= R('label_confirmpassword') ?>:</label>
   		<div class="col-sm-5">
    		<input maxlength="100" <?=$action == "new" ? "required":"" ?> class="form-control" type="password" name="confirm_passwd" placeholder="<?= R('label_confirmpassword') ?>" value="">
    	</div>
    </div>
     <?php if ($action == "edit") { ?>
     </div>
     <?php }?>
     <p>&nbsp;</p>
    <div class="col-sm-7">
     	
    <div class="pull-right">
    	<button type="submit" id="savebutton" class="btn btn-default" name="btnsubmit"><?= R('btn_save') ?></button>
    	<?php if ($action == "edit") { ?>
    	<input type="submit" class="btn btn-default" name="btndisable" onclick="return confirm('<?= R('label_confirm_disable_user') ?>')" value="<?= R('btn_disable') ?>">
    	<?php } ?>
    	<a href="<?= __SITEBASE ?>/users" class="btn btn-default" role="button"><?= R('btn_cancel') ?></a>
    	<?php if ($action == "edit") { ?>
    		<input type="hidden" id="password_changed" name="password_changed" value="">
    		<input type="hidden" name="id" value="<?= $user->id ?>">
    	<?php } ?>
    	<input type="hidden" name="orgid" id="orgid">
      
       
    </div>
    </div>
</form>
</div>
</div>
</div>
</div>
<script> 

function checkuser() {

	$('#usererror').html('<?= R('text_checking') ?>');
	
	$.ajax({
	        url: '<?= __SITEBASE ?>/users/userexists?username=' + $('#username').val(),
	        success: function (data) {
	           if (data==1) {
	        	   $('#usererror').html('<?= R('text_user_exists') ?>');
	        	   $('#usererror').addClass('text-danger');
	        	   $('#usernameformgroup').addClass( "has-error");
	        	   $('#savebutton').attr('disabled','disabled');
	           }else {
	        	   $('#usernameformgroup').removeClass( "has-error");
	        	   $('#usererror').html('');
	        	   $('#usererror').removeClass('text-danger');
	        	   $('#savebutton').removeAttr('disabled');
	           }
	        }, async: true
	    });
}

function change_roles(){
		
	$('#form1').attr("action","");
	$('#form1').submit();

}

<?php if ($user->id == 1 || $user->id == 2) { ?>

$(document).ready(function() {
    $('input').attr('disabled','disabled');
    $('select').attr('disabled','disabled');
    $('textarea').attr('disabled','disabled');
    $('button').attr('disabled','disabled');
});	 

<?php  } ?>	


</script>