<?php

/**
 * Explore Indicador (websig side)
 *
 * @author Fred
 * @version 1.0.1
 * @package Backend\SIG
 */


require_once 'app/class-lov-manager.php';

$list = $this->data['list'];
$aset = $this->data['assistedSet'];
$setString = (!isset($aset)) ? "": implode(",",$aset);
$arules = $this->data['rules'];
$navurl = $this->data['navkey'];

$ifvoid = count($list) > 0 ? "": " DISABLED "; 

$lovmanager = new LovManager();
$sexlist = $lovmanager->getLov_Sex();
$agegroup = $lovmanager->getLov_AgeGroup();
$countries = $lovmanager->getLov_Countries();
$formsofexplotation = $lovmanager->getLov_FormOfExploitation();
$recordstatuslist = $lovmanager->getLov_RecordStatus();

$victimstatus = $lovmanager->getLov_VictimStatus();
$traffstatus = $lovmanager->getLov_TraffickerStatus();

$simpleStatusList = array();
foreach ($recordstatuslist as $lc){
	$simpleStatusList[$lc->id] = $lc->descriptioncode;
}

?>

<div class="panel panel-default">
			<?php $this->load('common/message',$this) ?>
            


    <div class="panel-heading">
        <form class="form-horizontal" role="form">
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-6"><?= R('l_filters_for:') ?></label>
                <div class="col-sm-6">
                    <select id="mmi_type" class="form-control">
                        <option value="1"><?= D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></option>					  		
                        <option value="2"><?= D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) ?></option>
                    </select>
                </div>
            </div> 
        </form>
    </div>
    

    
    <div class="panel-body mosyParams">
        

        <form class="form-horizontal" role="form">
                      
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-4"><?= R('l_recruit_cntr') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_placeof_recruit" class="form-control input-sm">
                        <option value=""></option> 
                        <?php foreach ($countries as $item) { ?>
                            <option value="<?= $item->code ?>" ><?= D($item->descriptioncode) ?></option>
                        <?php } ?>
                    </select>
                </div>
                <button id="mmi_placeof_recruit_but" type="button" class="btn butgetcntr btn-xs" data-toggle="button"><span class="fa fa-crosshairs"></span></button>
            </div> 
            
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-4"><?= R('l_exploit_cntr') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_placeof_exploit" class="form-control input-sm">
                        <option value=""></option> 
                        <?php foreach ($countries as $item) { ?>
                            <option value="<?= $item->code ?>" ><?= D($item->descriptioncode) ?></option>
                        <?php } ?>
                    </select>
                </div>
                <button id="mmi_placeof_exploit_but" type="button" class="btn butgetcntr btn-xs" data-toggle="button"><span class="fa fa-crosshairs"></span></button>
            </div> 

            
            
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-4"><?= R('l_waypoint_cntr') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_placeof_waypoint" class="form-control input-sm">
                        <option value=""></option> 
                        <?php foreach ($countries as $item) { ?>
                            <option value="<?= $item->code ?>" ><?= D($item->descriptioncode) ?></option>
                        <?php } ?>
                    </select>
                </div>
                <button id="mmi_placeof_waypoint_but" type="button" class="btn butgetcntr btn-xs" data-toggle="button"><span class="fa fa-crosshairs"></span></button>
            </div>   
            
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-5"><?= R('l_formexploitation') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_formfexplotation" class="form-control input-sm" >
                        <option value=""></option> 
                            <?php foreach ($formsofexplotation as $item) { ?>
                                <option value="<?= $item->code ?>" <?= ($_POST['formofexplotation'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
                            <?php } ?>
                    </select>
                </div>
            </div>     
            
            <div class="form-group form-group-sm">
                <label class="control-label input-sm col-sm-5"><?= R('l_registration_datefrom') ?></label>
                <div class="col-sm-3">
                <select id="mmi_registdatefrom" name="year" class="control-label input-sm">
                    <option value=""></option> 
                    <?php for ($i = date('Y') - 5; $i <= date('Y'); $i++) { ?>
                        <option value="<?= $i ?>" <?= ($_POST['year'] == $i) ? "selected" : "" ?>><?= $i ?></option>
                    <?php } ?>
                </select>
                </div>

                <label class="control-label input-sm col-sm-1"><?= R('l_to') ?></label>
                <div class="col-sm-3">
                <select id="mmi_registdateto" name="year" class="control-label input-sm">
                    <option value=""></option> 
                    <?php for ($i = date('Y') - 5; $i <= date('Y'); $i++) { ?>
                        <option value="<?= $i ?>" <?= ($_POST['year'] == $i) ? "selected" : "" ?>><?= $i ?></option>
                    <?php } ?>
                </select>
                </div>
            </div> 
            
            
            
        <div id="mmi_morefilters">
            
            
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-5"><?= R('l_gender') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_gender" class="form-control input-sm" >
                        <option value=""></option> 
                    <?php foreach ($sexlist as $item) { ?>
                        <option value="<?= $item->code ?>"><?= D($item->descriptioncode) ?></option>
                    <?php } ?>
                    </select>
                </div>
            </div>  
            
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-4"><?= R('l_citizenship') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_citizenship" class="form-control input-sm" >
                        <option value=""></option> 
                            <?php foreach ($countries as $item) { ?>
                                <option value="<?= $item->code ?>"><?= D($item->descriptioncode) ?></option>
                            <?php } ?>
                    </select>                   
                </div>
                <button id="mmi_citizenship_but" type="button" class="btn butgetcntr btn-xs" data-toggle="button"><span class="fa fa-crosshairs"></span></button>
            </div> 
            
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-5"><?= R('l_agegroup') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_agegroup" class="form-control input-sm" >
                        <option value=""></option> 
                        <?php foreach ($agegroup as $item) { ?>
                            <option value="<?= $item->code ?>"><?= D($item->descriptioncode) ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div> 
   
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-5"><?= R('l_status') ?></label>
                <div class="col-sm-7">
                    <select id="mmi_status" class="form-control input-sm" >
                        <option value=""></option> 
                        <?php foreach ($victimstatus as $item) { ?>
                            <option value="<?= $item->code ?>"> <?= D($item->descriptioncode) ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>      
            
            <div class="form-group form-group-sm">
                <label class="control-label input-sm col-sm-5"><?= R('l_recruitment_datefrom') ?></label>
                <div class="col-sm-3">
                <select id="mmi_recruitdatefrom" name="year" class="control-label input-sm">
                    <option value=""></option> 
                    <?php for ($i = date('Y') - 5; $i <= date('Y'); $i++) { ?>
                        <option value="<?= $i ?>" <?= ($_POST['year'] == $i) ? "selected" : "" ?>><?= $i ?></option>
                    <?php } ?>
                </select>
                </div>
                <label class="control-label input-sm col-sm-1"><?= R('l_to') ?></label>
                <div class="col-sm-3">
                <select id="mmi_recruitdateto" name="year" class="control-label input-sm">
                    <option value=""></option> 
                    <?php for ($i = date('Y') - 5; $i <= date('Y'); $i++) { ?>
                        <option value="<?= $i ?>" <?= ($_POST['year'] == $i) ? "selected" : "" ?>><?= $i ?></option>
                    <?php } ?>
                </select>
                </div>
            </div> 
        </div>

</form>


        
        <a id="mmi_morefilters_button" href="#" btnaction="true" class="btn btn-default btn-xs" onclick="morefilter();"><?= R("l_more_filter") ?></a>
        <a href="#" btnaction="true" class="btn btn-default btn-xs" onclick="clean();"><?= R("l_clear_filter") ?></a> 
    </div>                
</div>



<div class="panel panel-default">
    <div class="panel-heading"><?= R('websig_indicator_map_params') ?></div>
    <div class="panel-body">

        

        <form class="form-horizontal" role="form">
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-6"><?= R('layer_name') ?>&nbsp;
                    <span class="fa fa-expand"></span>&nbsp;<span class="fa fa-globe"></span></label>
                <div class="col-sm-6">
                    <input type="text" class="form-control input-sm" id="mmi_layer_name">
                </div>
            </div> 
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-6"><?= R('l_geo_context') ?>&nbsp;
                    <span class="fa fa-bullseye">&nbsp;</span><span class="fa fa-expand"></span>&nbsp;<span class="fa fa-globe"></span></label>
                <div class="col-sm-6">
                    <select name="indic_geocontext" class="form-control input-sm" id="mmi_geo_context">
                            <option value="3" ><?= R('NUTs 3') ?></option>
                            <option value="2" ><?= R('NUTs 2') ?></option>
                            <option value="1" ><?= R('NUTs 1') ?></option>
                            <option value="0" selected><?= R('Countries') ?></option>
                            <!--<option value="nuts0" ><?= R('NUTs 0') ?></option>-->
                    </select>
                </div>
            </div> 

            <div class="form-group form-group-sm">
                <label class="control-label col-sm-6"><?= R('class_number') ?>&nbsp;
                    <span class="fa fa-expand"></span>&nbsp;<span class="fa fa-globe"></span></label>
                <div class="col-sm-4">
                    <select name="indic_nb_classes" class="form-control input-sm" id="mmi_nb_classes">
                        <?php for ($x = 2; $x <= 9; $x++) { ?>
                            <option value="<?= $x ?>" <?= ($x == 5) ? "selected" : "" ?>><?= $x ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div> 

            <div class="form-group form-group-sm">
                <label class="control-label col-sm-6"><?= R('Use Flight Route line') ?>&nbsp;<span class="fa fa-expand"></span></label>
                <div class="col-sm-4">
                    <select name="indic_graph_fly_view" class="form-control input-sm" id="mmi_fly_view">
                            <option value="true" selected><?= R('True') ?></option>
                            <option value="false" ><?= R('False') ?></option>
                    </select>
                </div>
            </div>    
            
            <div class="form-group form-group-sm">
                <label class="control-label col-sm-6"><?= R('Opacity') ?>&nbsp;<span class="fa fa-globe"></span></label>
                <div class="col-sm-4">
                    <select name="indic_per_trans" class="form-control input-sm" id="mmi_percent_transp">
                        <?php for ($x = 10; $x <= 100; $x+=10) { ?>
                            <option value="<?= $x ?>" <?= ($x == 80) ? "selected" : "" ?>><?= $x ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>  

            <div class="form-group form-group-sm">
                <label class="control-label col-sm-6"><?= R('color_scheme') ?>&nbsp;<span class="fa fa-globe"></span></label>
                <div class="col-sm-6">
                    <select name="indic_color_scheme" class="form-control input-sm" id="mmi_color_scheme">
                            <option value="discrete"><?= R('Discrete') ?></option>
                            <option value="ramp"><?= R('Ramp') ?></option>
                    </select>
                </div>
            </div>  
                    <div id="rampcolorselect">
                <label class="control-label" ><?= R('From color') ?></label>
                <input type="text" id="ramp_color1" value="rgb(111, 168, 220)" class="rampcolor" />
                <label class="control-label" ><?= R('To color') ?></label>
                <input type="text" id="ramp_color2" value="rgb(224, 102, 102)" class="rampcolor" />  
        </div> 
            
    
       </form>

            

    </div>
</div>

<div class="text-center">
   <button type="button" class="btn btn-primary" id="mmi_btnGetIndicatorsRec">
       <span class="fa fa-globe"></span> <?= R('Choropleth Map') ?>
   </button>
   <button type="button" class="btn btn-primary" id="mmi_btnGetGraph">
       <span class="fa fa-expand"></span> <?= R('Graph Map') ?>
   </button>
    </div>
<p></p>
<div class="text-center">
   <button type="button" class="btn btn-primary" id="mmi_btnGetCluster">
       <span class="fa fa-bullseye"></span> <?= R('Cluster Map') ?>
   </button>
</div>





<script>
    
function morefilter () {
    if ($('#mmi_morefilters').is(":visible") ) {
        $('#mmi_morefilters').fadeOut('slow');
        $('#mmi_morefilters_button').text('<?= R("l_more_filter") ?>');
        
    } else {
        $('#mmi_morefilters').fadeIn('slow');
        $('#mmi_morefilters_button').text('<?= R("l_less_filter") ?>');
        
    }
}

function clean() {

	$('#birthdate').val('');
        
        
	//$('div.mosyParams option:selected').children().removeAttr('selected');
        $('.mosyParams select option:selected').removeAttr('selected');
}


function runRule(){
	$('#formcolnfp').attr('action','<?= __SITEBASE ?>/nfpcollect/runrule');
}

function toggleAction(action) {

	$('#tainted').val('1');
	
	if (action == 'cluster')
	{
		$('#formcolnfp').attr('action','<?= __SITEBASE ?>/clusterdetail/newcluster');
	}
	if (action == 'compare')
	{
		$('#formcolnfp').attr('action','<?= __SITEBASE ?>/comparerecords/');
	}
}

function validate_checks() {

	if ($('#tainted').val() == '1')
	{
		if (1==1) {
			return true;
		}
		else {
			$('#tainted').val('0');
		 	$("#formcolnfp").attr("action",'<?= __SITEBASE ?>/nfpcollect');
			return false;
		}
	}
}



 </script>   
